/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lehjr.numina.common.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecType;
import lehjr.numina.common.map.NuminaRegistry;
import lehjr.numina.common.math.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;

public abstract class SpecBase
extends NuminaRegistry<PartSpecBase> {
    private final String name;
    private final boolean isDefault;
    private final SpecType specType;
    private List<Integer> colors = new ArrayList(){
        {
            this.add(Color.WHITE.getARGBInt());
        }
    };

    public SpecBase(String name, boolean isDefault, SpecType specType) {
        this.name = name;
        this.isDefault = isDefault;
        this.specType = specType;
    }

    public abstract Component getDisaplayName();

    public Iterable<PartSpecBase> getPartSpecs() {
        return this.elems();
    }

    public Stream<PartSpecBase> getPartsAsStream() {
        return this.elemsAsStream();
    }

    public boolean hasArmorEquipmentSlot(EquipmentSlot slot) {
        return this.elemsAsStream().map(partSpecBase -> partSpecBase.getBinding().getSlot().equals((Object)slot) && slot.m_20743_() == EquipmentSlot.Type.ARMOR).findFirst().isPresent();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public SpecType getSpecType() {
        return this.specType;
    }

    public List<Integer> getColors() {
        return this.colors;
    }

    public int addColorIfNotExist(Color color) {
        int colorInt = color.getARGBInt();
        if (!this.colors.contains(colorInt)) {
            this.colors.add(colorInt);
            return this.colors.size() - 1;
        }
        return this.colors.indexOf(colorInt);
    }

    public abstract String getOwnName();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecBase specBase = (SpecBase)o;
        return Objects.equals(this.name, specBase.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.isDefault, this.specType, this.colors});
    }
}

