/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.tags;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TagUtils {
    public static CompoundTag getMuseModularItemTag(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return new CompoundTag();
        }
        CompoundTag stackTag = stack.m_41784_();
        CompoundTag properties = stackTag.m_128441_("MMModItem") ? stackTag.m_128469_("MMModItem") : new CompoundTag();
        stackTag.m_128365_("MMModItem", (Tag)properties);
        stack.m_41751_(stackTag);
        return properties;
    }

    public static CompoundTag getModuleTag(@Nonnull ItemStack module) {
        if (module.m_41619_()) {
            return new CompoundTag();
        }
        CompoundTag stackTag = module.m_41784_();
        CompoundTag properties = stackTag.m_128441_("MMModModule") ? stackTag.m_128469_("MMModModule") : new CompoundTag();
        stackTag.m_128365_("MMModModule", (Tag)properties);
        module.m_41751_(stackTag);
        return properties;
    }

    public static float getModuleFloatOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getFloatOrZero(TagUtils.getModuleTag(stack), string);
    }

    public static float getModularItemFloatOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getFloatOrZero(TagUtils.getMuseModularItemTag(stack), string);
    }

    public static float getFloatOrZero(CompoundTag nbt, String tagName) {
        return nbt.m_128425_(tagName, 5) ? nbt.m_128457_(tagName) : 0.0f;
    }

    public static void setModularItemFloatOrRemove(@Nonnull ItemStack stack, String string, float value) {
        TagUtils.setFloatOrRemove(TagUtils.getMuseModularItemTag(stack), string, value);
    }

    public static void setModuleFloatOrRemove(@Nonnull ItemStack stack, String string, float value) {
        TagUtils.setFloatOrRemove(TagUtils.getModuleTag(stack), string, value);
    }

    public static void setFloatOrRemove(CompoundTag itemProperties, String string, float value) {
        if (itemProperties != null) {
            if (Float.compare(value, 0.0f) == 0) {
                itemProperties.m_128473_(string);
            } else {
                itemProperties.m_128350_(string, value);
            }
        }
    }

    public static double getModuleDoubleOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getDoubleOrZero(TagUtils.getModuleTag(stack), string);
    }

    public static double getModularItemDoubleOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getDoubleOrZero(TagUtils.getMuseModularItemTag(stack), string);
    }

    public static double getDoubleOrZero(CompoundTag nbt, String tagName) {
        return nbt.m_128425_(tagName, 6) ? nbt.m_128459_(tagName) : 0.0;
    }

    public static void setModularItemDoubleOrRemove(@Nonnull ItemStack stack, String string, double value) {
        TagUtils.setDoubleOrRemove(TagUtils.getMuseModularItemTag(stack), string, value);
    }

    public static void setModuleDoubleOrRemove(@Nonnull ItemStack stack, String string, double value) {
        TagUtils.setDoubleOrRemove(TagUtils.getModuleTag(stack), string, value);
    }

    public static void setDoubleOrRemove(CompoundTag itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.m_128473_(string);
            } else {
                itemProperties.m_128347_(string, value);
            }
        }
    }

    public static int getModuleIntOrZero(@Nonnull ItemStack module, String string) {
        return TagUtils.getIntOrZero(TagUtils.getModuleTag(module), string);
    }

    public static int getModularItemIntOrZero(@Nonnull ItemStack module, String string) {
        return TagUtils.getIntOrZero(TagUtils.getMuseModularItemTag(module), string);
    }

    static int getIntOrZero(CompoundTag nbt, String tagName) {
        return nbt.m_128425_(tagName, 3) ? nbt.m_128451_(tagName) : 0;
    }

    public static void setModuleIntOrRemove(@Nonnull ItemStack stack, String tagName, int value, boolean remove) {
        TagUtils.setIntOrRemove(TagUtils.getModuleTag(stack), tagName, value, remove);
    }

    public static void setModularItemIntOrRemove(@Nonnull ItemStack stack, String tagName, int value, boolean remove) {
        TagUtils.setIntOrRemove(TagUtils.getMuseModularItemTag(stack), tagName, value, remove);
    }

    public static void setIntOrRemove(@Nonnull CompoundTag nbt, String tagName, int value, boolean remove) {
        if (value == 0 && remove) {
            nbt.m_128473_(tagName);
        } else {
            nbt.m_128405_(tagName, value);
        }
    }

    public static boolean getModuleBooleanOrSetDefault(@Nonnull ItemStack module, String tagName, boolean defBool) {
        CompoundTag moduleTag = TagUtils.getModuleTag(module);
        if (moduleTag.m_128425_(tagName, 1)) {
            return TagUtils.getBooleanOrFalse(moduleTag, tagName);
        }
        moduleTag.m_128379_(tagName, defBool);
        return defBool;
    }

    public static boolean getModuleBooleanOrFalse(@Nonnull ItemStack module, String string) {
        return TagUtils.getBooleanOrFalse(TagUtils.getModuleTag(module), string);
    }

    public static boolean getItemBooleanOrFalse(@Nonnull ItemStack module, String string) {
        return TagUtils.getBooleanOrFalse(TagUtils.getMuseModularItemTag(module), string);
    }

    static boolean getBooleanOrFalse(CompoundTag nbt, String tagName) {
        return nbt.m_128425_(tagName, 1) ? nbt.m_128471_(tagName) : false;
    }

    public static void setModuleBoolean(@Nonnull ItemStack module, String string, boolean value) {
        TagUtils.getModuleTag(module).m_128379_(string, value);
    }

    public static void setModularItemBoolean(@Nonnull ItemStack module, String string, boolean value) {
        TagUtils.getMuseModularItemTag(module).m_128379_(string, value);
    }

    public static void setModuleResourceLocation(@Nonnull ItemStack module, String string, ResourceLocation value) {
        TagUtils.getModuleTag(module).m_128359_(string, value.toString());
    }

    public static Optional<ResourceLocation> getModuleResourceLocation(@Nonnull ItemStack module, String string) {
        CompoundTag moduleTag = TagUtils.getModuleTag(module);
        if (moduleTag.m_128425_(string, 8)) {
            return Optional.of(new ResourceLocation(moduleTag.m_128461_(string)));
        }
        return Optional.empty();
    }
}

