/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.entity.goal;

import com.scarasol.pillagers_gun.item.gun.GunItem;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class GunAttackGoal<T extends Mob>
extends Goal {
    public static MobEffect CONFUSION = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("sona:confusion"));
    public static MobEffect BLIND = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("lrtactical:blinded"));
    private final T mob;
    private GunState gunState = GunState.UNCHARGED;
    private final double speedModifier;
    private int seeTime;
    private int attackDelay;
    private int ammoCount;
    private boolean away;
    private boolean stopped;

    public GunAttackGoal(T mob, double speedModifier, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public static boolean isStunned(LivingEntity mob) {
        return mob.m_21023_(CONFUSION) || mob.m_21023_(BLIND);
    }

    public boolean m_8036_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo() || GunAttackGoal.isStunned(this.mob));
    }

    private boolean isHoldingGun() {
        return this.mob.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GunItem;
    }

    public boolean m_8045_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo() || GunAttackGoal.isStunned(this.mob));
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean hasAmmo() {
        return GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND));
    }

    private boolean isRightAngle() {
        if (GunAttackGoal.isStunned(this.mob)) {
            return true;
        }
        if (this.isValidTarget()) {
            LivingEntity target = this.mob.m_5448_();
            return this.vectorDegreeCalculate(this.mob.m_20252_(1.0f), target.m_146892_().m_82546_(this.mob.m_146892_())) < 10.0 + Math.max(0.0, 64.0 - this.mob.m_20280_((Entity)target));
        }
        return false;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            GunItem.setCharged(this.mob.m_21211_(), false);
        }
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        InteractionHand interactionhand;
        ItemStack itemstack;
        Item crossbowAttackMob3;
        LivingEntity livingentity = this.mob.m_5448_();
        boolean flag2 = false;
        boolean flag = false;
        double attackRadius = this.mob.m_21172_(Attributes.f_22277_);
        boolean isStunned = GunAttackGoal.isStunned(this.mob);
        if (this.isValidTarget()) {
            this.mob.m_21561_(true);
            double d0 = livingentity.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_();
            boolean bl = flag = this.mob.m_21574_().m_148306_((Entity)livingentity) && !isStunned;
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!isStunned) {
                if (d0 <= attackRadius && this.seeTime > 5) {
                    if (!this.hasAmmo()) {
                        this.stopped = false;
                        if (d0 < attackRadius / 2.0) {
                            this.away = true;
                            Vec3 vec3 = this.mob.m_20182_().m_82549_(this.mob.m_20182_().m_82492_(livingentity.m_20182_().f_82479_, this.mob.m_20182_().f_82480_, livingentity.m_20182_().f_82481_).m_82541_().m_82490_(attackRadius / 2.0));
                            this.mob.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
                        }
                        if (this.away && d0 > attackRadius * 2.0 / 3.0) {
                            this.mob.m_21573_().m_26573_();
                            this.away = false;
                        } else if (!this.away && d0 < attackRadius * 2.0 / 3.0) {
                            this.mob.m_21573_().m_26573_();
                        }
                    } else if (this.hasAmmo() && !this.stopped) {
                        this.mob.m_21573_().m_26573_();
                        this.stopped = true;
                    }
                } else {
                    this.stopped = false;
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                }
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            boolean bl2 = flag2 = (d0 > attackRadius || this.seeTime < 5) && this.attackDelay == 0;
        }
        if (this.gunState == GunState.UNCHARGED && GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND))) {
            this.gunState = GunState.CHARGED;
            this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
            this.ammoCount = GunItem.getCurrentAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND));
        }
        if (this.gunState == GunState.CHARGED && !GunItem.isCharged(this.mob.m_21120_(InteractionHand.MAIN_HAND))) {
            this.gunState = GunState.UNCHARGED;
        }
        if (this.gunState == GunState.UNCHARGED) {
            if (!flag2 && !isStunned) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
                this.gunState = GunState.CHARGING;
                T t = this.mob;
                if (t instanceof CrossbowAttackMob) {
                    CrossbowAttackMob crossbowAttackMob2 = (CrossbowAttackMob)t;
                    crossbowAttackMob2.m_6136_(true);
                }
            }
        } else if (this.gunState == GunState.CHARGING) {
            if (!this.mob.m_6117_()) {
                this.gunState = GunState.UNCHARGED;
            }
            int i = this.mob.m_21252_();
            ItemStack itemstack2 = this.mob.m_21211_();
            Item item2 = itemstack2.m_41720_();
            if (item2 instanceof GunItem) {
                GunItem gun = (GunItem)item2;
                if (i >= GunItem.getChargeDuration(itemstack2)) {
                    this.mob.m_21253_();
                    this.gunState = GunState.CHARGED;
                    this.attackDelay = 10 + this.mob.m_217043_().m_188503_(20) + gun.getCooldownTime();
                    this.ammoCount = GunItem.getCurrentAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND));
                    T t = this.mob;
                    if (t instanceof CrossbowAttackMob) {
                        CrossbowAttackMob crossbowAttackMob3 = (CrossbowAttackMob)t;
                        crossbowAttackMob3.m_6136_(false);
                    }
                }
            }
        } else if (this.gunState == GunState.CHARGED) {
            if (--this.attackDelay <= 0) {
                this.gunState = GunState.READY_TO_ATTACK;
            }
        } else if (this.gunState == GunState.READY_TO_ATTACK && (flag || isStunned) && this.isRightAngle() && (crossbowAttackMob3 = (itemstack = this.mob.m_21120_(interactionhand = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem))).m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)crossbowAttackMob3;
            float inaccuracy = gunItem.getInaccuracy();
            if (isStunned) {
                inaccuracy += 8.0f;
            }
            GunItem.performShooting(this.mob.m_9236_(), this.mob, interactionhand, itemstack, inaccuracy);
            --this.ammoCount;
            ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
            if (this.ammoCount <= 0) {
                GunItem.setCharged(itemstack1, false);
                this.gunState = GunState.UNCHARGED;
            } else {
                this.gunState = GunState.CHARGED;
                Item item3 = itemstack1.m_41720_();
                if (item3 instanceof GunItem) {
                    GunItem gun = (GunItem)item3;
                    this.attackDelay = gun.getCooldownTime();
                }
            }
        }
    }

    private boolean canRun() {
        return this.gunState != GunState.CHARGING;
    }

    public double vectorDegreeCalculate(Vec3 vec1, Vec3 vec2) {
        double cos = vec1.m_82526_(vec2) / vec1.m_82553_() / vec2.m_82553_();
        return Math.toDegrees(Math.acos(cos));
    }

    static enum GunState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

