/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.recipe.CrystallizerRecipe;

public class CrystallizerEntity
extends AbstractCrystallizerEntity {
    public CrystallizerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CRYSTALLIZER.get(), pos, state);
    }

    @Override
    public Fluid getDesiredFluid() {
        return (Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    protected boolean hasIngredients() {
        Level level = this.m_58904_();
        SimpleContainer inventory = new SimpleContainer(5);
        inventory.m_6836_(0, this.crystalBaseHandler.getStackInSlot(0));
        inventory.m_6836_(1, this.primaryIngredientHandler.getStackInSlot(0));
        inventory.m_6836_(2, this.secondaryIngredientHandler.getStackInSlot(0));
        inventory.m_6836_(3, this.outputHandler.getStackInSlot(0));
        inventory.m_6836_(4, this.fluidInputHandler.getStackInSlot(0));
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CrystallizerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (!recipe.isPresent()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.enable_classic_stargate_upgrades.get()).booleanValue() && ((CrystallizerRecipe)recipe.get()).m_8043_((RegistryAccess)level.m_7654_().m_206579_()).m_41720_() instanceof StargateUpgradeItem) {
            return false;
        }
        return CrystallizerEntity.hasSpaceInOutputSlot(inventory, ((CrystallizerRecipe)recipe.get()).m_8043_((RegistryAccess)level.m_7654_().m_206579_()));
    }

    @Override
    protected void crystallize() {
        Level level = this.m_58904_();
        SimpleContainer inventory = new SimpleContainer(5);
        inventory.m_6836_(0, this.crystalBaseHandler.getStackInSlot(0));
        inventory.m_6836_(1, this.primaryIngredientHandler.getStackInSlot(0));
        inventory.m_6836_(2, this.secondaryIngredientHandler.getStackInSlot(0));
        inventory.m_6836_(3, this.outputHandler.getStackInSlot(0));
        inventory.m_6836_(4, this.fluidInputHandler.getStackInSlot(0));
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CrystallizerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (this.hasIngredients()) {
            ItemStack outputStack;
            this.useUpItems((CrystallizerRecipe)recipe.get(), 0);
            if (((CrystallizerRecipe)recipe.get()).depletePrimary()) {
                this.useUpItems((CrystallizerRecipe)recipe.get(), 1);
            }
            if (((CrystallizerRecipe)recipe.get()).depleteSecondary()) {
                this.useUpItems((CrystallizerRecipe)recipe.get(), 2);
            }
            if ((outputStack = this.outputHandler.getStackInSlot(0)).m_41619_()) {
                this.outputHandler.setStackInSlot(0, ((CrystallizerRecipe)recipe.get()).m_8043_(null));
            } else if (((CrystallizerRecipe)recipe.get()).m_8043_(null).m_150930_(outputStack.m_41720_())) {
                outputStack.m_41769_(1);
            }
            this.progress = 0;
        }
    }

    protected void useUpItems(CrystallizerRecipe recipe, int slot) {
        switch (slot) {
            case 1: {
                this.primaryIngredientHandler.extractItem(0, recipe.getAmountInSlot(1), false);
                break;
            }
            case 2: {
                this.secondaryIngredientHandler.extractItem(0, recipe.getAmountInSlot(2), false);
                break;
            }
            default: {
                this.crystalBaseHandler.extractItem(0, recipe.getAmountInSlot(0), false);
            }
        }
    }
}

