/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public enum Orientation implements StringRepresentable
{
    REGULAR("regular", 1, 0),
    UPWARD("upward", 0, 1),
    DOWNWARD("downward", 2, -1);

    private static final Vec3[] VECTORS;
    private String name;
    private int data2d;
    private int index;

    private Orientation(String name, int data2d, int index) {
        this.name = name;
        this.data2d = data2d;
        this.index = index;
    }

    public String m_7912_() {
        return this.name;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public int getIndex() {
        return this.index;
    }

    public static Orientation getOrientationFromXRot(Player player) {
        if (player == null) {
            return REGULAR;
        }
        float rotation = player.m_146909_();
        if (rotation > 65.0f) {
            return UPWARD;
        }
        if (rotation < -65.0f) {
            return DOWNWARD;
        }
        return REGULAR;
    }

    public static Direction getCenterDirection(Direction facingDirection, Orientation orientation) {
        if (orientation != null && facingDirection != null) {
            switch (orientation) {
                case UPWARD: {
                    return facingDirection.m_122424_();
                }
                case DOWNWARD: {
                    return facingDirection;
                }
            }
        }
        return Direction.UP;
    }

    public static Direction getForwardDirection(Direction facingDirection, Orientation orientation) {
        if (orientation != null) {
            switch (orientation) {
                case UPWARD: {
                    return Direction.UP;
                }
                case DOWNWARD: {
                    return Direction.DOWN;
                }
            }
        }
        return facingDirection;
    }

    public static Direction getMultiDirection(Direction facingDirection, Direction direction, Orientation orientation) {
        if (orientation == REGULAR) {
            return direction;
        }
        if (direction != null) {
            switch (direction) {
                case UP: {
                    return orientation == UPWARD ? facingDirection.m_122424_() : facingDirection;
                }
                case DOWN: {
                    return orientation == UPWARD ? facingDirection : facingDirection.m_122424_();
                }
            }
            return Orientation.getForwardDirection(facingDirection, orientation);
        }
        return facingDirection;
    }

    public static Vec3 getForwardVector(Direction facingDirection, Orientation orientation) {
        if (orientation != null) {
            switch (orientation) {
                case UPWARD: {
                    return VECTORS[1];
                }
                case DOWNWARD: {
                    return VECTORS[0];
                }
            }
        }
        return VECTORS[facingDirection.m_122411_()];
    }

    public static Vec3 getUpVector(Direction facingDirection, Orientation orientation) {
        if (orientation != null && facingDirection != null) {
            switch (orientation) {
                case UPWARD: {
                    return VECTORS[facingDirection.m_122424_().m_122411_()];
                }
                case DOWNWARD: {
                    return VECTORS[facingDirection.m_122411_()];
                }
            }
        }
        return VECTORS[1];
    }

    static {
        VECTORS = new Vec3[]{new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, -1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0)};
    }
}

