/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.computer_functions;

import java.util.ArrayList;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.info.AddressFilterInfo;

public class StargateFilterFunctions {
    public static int getFilterType(AbstractStargateEntity stargate) {
        return stargate.addressFilterInfo().getFilterType().getIntegerValue();
    }

    public static int setFilterType(AbstractStargateEntity stargate, int filterType) {
        return stargate.addressFilterInfo().setFilterType(filterType).getIntegerValue();
    }

    public static String addToWhitelist(AbstractStargateEntity stargate, int[] addressArray, boolean isVisible) {
        if (stargate.addressFilterInfo().addToWhitelist(new Address(addressArray).immutable(), isVisible)) {
            return "Address whitelisted successfully";
        }
        return "Address visibility changed successfully";
    }

    public static String addToBlacklist(AbstractStargateEntity stargate, int[] addressArray, boolean isVisible) {
        if (stargate.addressFilterInfo().addToBlacklist(new Address(addressArray).immutable(), isVisible)) {
            return "Address blacklisted successfully";
        }
        return "Address visibility changed successfully";
    }

    public static String removeFromWhitelist(AbstractStargateEntity stargate, int[] addressArray) {
        if (stargate.addressFilterInfo().removeFromWhitelist(new Address(addressArray).immutable())) {
            return "Address removed from whitelist successfully";
        }
        return "Address is not whitelisted";
    }

    public static String removeFromBlacklist(AbstractStargateEntity stargate, int[] addressArray) {
        if (stargate.addressFilterInfo().removeFromBlacklist(new Address(addressArray).immutable())) {
            return "Address removed from blacklist successfully";
        }
        return "Address is not blacklisted";
    }

    public static ArrayList<Address.Immutable> getPublicWhitelist(AbstractStargateEntity stargate) {
        ArrayList<Address.Immutable> addresses = new ArrayList<Address.Immutable>();
        for (AddressFilterInfo.HiddenAddress address : stargate.addressFilterInfo().getWhitelist()) {
            if (!address.isVisible()) continue;
            addresses.add(address.address());
        }
        return addresses;
    }

    public static ArrayList<Address.Immutable> getPublicBlacklist(AbstractStargateEntity stargate) {
        ArrayList<Address.Immutable> addresses = new ArrayList<Address.Immutable>();
        for (AddressFilterInfo.HiddenAddress address : stargate.addressFilterInfo().getBlacklist()) {
            if (!address.isVisible()) continue;
            addresses.add(address.address());
        }
        return addresses;
    }

    public static String clearWhitelist(AbstractStargateEntity stargate) {
        stargate.addressFilterInfo().clearWhitelist();
        return "Whitelist cleared";
    }

    public static String clearBlacklist(AbstractStargateEntity stargate) {
        stargate.addressFilterInfo().clearBlacklist();
        return "Blacklist cleared";
    }
}

