/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.entities.goals.StaffWeaponAttackGoal;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public abstract class Anthropoid
extends AgeableMob
implements RangedAttackMob {
    private final StaffWeaponAttackGoal staffWeaponGoal = new StaffWeaponAttackGoal<Anthropoid>(this, 1.0, 8.0f, 12.0f);
    private final RangedBowAttackGoal<Anthropoid> bowGoal = new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void m_8041_() {
            super.m_8041_();
            Anthropoid.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            Anthropoid.this.m_21561_(true);
        }
    };

    public Anthropoid(EntityType<? extends Anthropoid> type, Level level) {
        super(type, level);
        this.reassessWeaponGoal();
    }

    public abstract ResourceLocation texture();

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public void reassessWeaponGoal() {
        if (this.m_9236_() == null || this.m_9236_().m_5776_()) {
            return;
        }
        this.f_21345_.m_25363_((Goal)this.meleeGoal);
        this.f_21345_.m_25363_(this.bowGoal);
        this.f_21345_.m_25363_((Goal)this.staffWeaponGoal);
        ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> Anthropoid.isWeapon(item)));
        if (itemstack.m_41720_() instanceof StaffWeaponItem) {
            this.f_21345_.m_25352_(2, (Goal)this.staffWeaponGoal);
        } else if (itemstack.m_41720_() instanceof BowItem) {
            int i = 20;
            if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                i = 40;
            }
            this.bowGoal.m_25797_(i);
            this.f_21345_.m_25352_(4, this.bowGoal);
        } else {
            this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        this.m_21553_(true);
        spawnGroupData = super.m_6518_(level, difficulty, type, spawnGroupData, tag);
        this.reassessWeaponGoal();
        return spawnGroupData;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.reassessWeaponGoal();
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        if (!this.m_9236_().m_5776_()) {
            this.reassessWeaponGoal();
        }
    }

    public void m_6504_(LivingEntity entity, float distanceFactor) {
        if (this.m_21205_().m_41720_() instanceof StaffWeaponItem) {
            this.performStaffWeaponAttack(entity, distanceFactor);
        } else {
            this.performBowAttack(entity, distanceFactor);
        }
    }

    protected void performBowAttack(LivingEntity entity, float distanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = entity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected void performStaffWeaponAttack(LivingEntity entity, float distanceFactor) {
        StaffWeaponItem staffWeapon;
        ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof StaffWeaponItem));
        Item item2 = itemstack.m_41720_();
        if (item2 instanceof StaffWeaponItem && (staffWeapon = (StaffWeaponItem)item2).tryDepleteLiquidNaquadah(itemstack)) {
            PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends Projectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)this, this.m_9236_(), staffWeapon.getExplosionPower(itemstack));
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - plasmaProjectile.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double distance = Math.sqrt(x * x + z * z);
            plasmaProjectile.m_6686_(x, y + distance * 0.125, z, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_5496_((SoundEvent)SoundInit.MATOK_FIRE.get(), 0.25f, 1.0f);
            this.m_9236_().m_7967_((Entity)plasmaProjectile);
        }
    }

    public static boolean isWeapon(Item item) {
        if (item instanceof SwordItem) {
            return true;
        }
        if (item instanceof StaffWeaponItem) {
            return true;
        }
        if (item instanceof BowItem) {
            return true;
        }
        return item instanceof CrossbowItem;
    }
}

