/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.capabilities.AncientGeneProvider;
import net.povstalec.sgjourney.common.config.CommonGeneticConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.Nullable;

public class SyringeItem
extends Item {
    public SyringeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && player.m_6144_() && this.tryToApplyEffects((Entity)player, player.m_21120_(hand))) {
            player.m_21120_(hand).m_41783_().m_128359_("Contents", Contents.EMPTY.name());
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.syringe.contents").m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.GRAY));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Contents")) {
            Contents contents = Contents.valueOf(stack.m_41783_().m_128461_("Contents"));
            String text = contents.getText();
            tooltipComponents.add((Component)Component.m_237115_((String)text).m_130940_(contents.getFormatting()));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.syringe.empty").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    private boolean tryToApplyEffects(Entity target, ItemStack stack) {
        if (stack.m_41782_()) {
            Contents contents = Contents.valueOf(stack.m_41783_().m_128461_("Contents"));
            switch (contents) {
                case EMPTY: {
                    return false;
                }
                case BLOOD: {
                    return false;
                }
                case PROTOTYPE_ATA: {
                    return this.applyAncientGene(target, CommonGeneticConfig.prototype_ata_gene_therapy_success_rate.get());
                }
                case ATA: {
                    return this.applyAncientGene(target, CommonGeneticConfig.ata_gene_therapy_success_rate.get());
                }
            }
        }
        return false;
    }

    private boolean applyAncientGene(Entity target, int probability) {
        if (!target.getCapability(AncientGeneProvider.ANCIENT_GENE).isPresent()) {
            return false;
        }
        target.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> {
            if (cap.isLacking()) {
                Random random = new Random();
                int chance = random.nextInt(1, 101);
                if (chance <= probability) {
                    cap.implantGene();
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        player.m_213846_((Component)Component.m_237115_((String)"message.sgjourney.syringe.got_ancient_gene").m_130940_(ChatFormatting.AQUA));
                    }
                }
            } else if (target instanceof Player) {
                Player player = (Player)target;
                player.m_213846_((Component)Component.m_237115_((String)"message.sgjourney.syringe.has_ancient_gene").m_130940_(ChatFormatting.AQUA));
            }
        });
        return true;
    }

    public static ItemStack addContents(Contents contents) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.SYRINGE.get());
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("Contents", contents.name());
        stack.m_41751_(compoundtag);
        return stack;
    }

    public static enum Contents {
        EMPTY("tooltip.sgjourney.syringe.empty", ChatFormatting.GRAY),
        BLOOD("tooltip.sgjourney.syringe.blood", ChatFormatting.DARK_RED),
        PROTOTYPE_ATA("tooltip.sgjourney.syringe.prototype_ata_gene", ChatFormatting.AQUA),
        ATA("tooltip.sgjourney.syringe.ata_gene", ChatFormatting.AQUA);

        private String text;
        private ChatFormatting formatting;

        private Contents(String text, ChatFormatting formatting) {
            this.text = text;
            this.formatting = formatting;
        }

        public String getText() {
            return this.text;
        }

        public ChatFormatting getFormatting() {
            return this.formatting;
        }
    }
}

