/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.structures.SGJourneyStructure;
import org.jetbrains.annotations.Nullable;

public abstract class StargateStructure
extends SGJourneyStructure {
    private static Optional<Long> currentSeed = Optional.empty();
    private static Optional<Integer> x = Optional.empty();
    private static Optional<Integer> z = Optional.empty();
    @Nullable
    protected StargateModifiers stargateModifiers;
    @Nullable
    protected DHDModifiers dhdModifiers;

    public StargateStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Boolean> commonStargates, Optional<StargateModifiers> stargateModifiers, Optional<DHDModifiers> dhdModifiers) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, commonStargates);
        this.stargateModifiers = stargateModifiers.orElse(null);
        this.dhdModifiers = dhdModifiers.orElse(null);
    }

    private static final void checkSeed(long seed) {
        if (currentSeed.isEmpty() || currentSeed.isPresent() && currentSeed.get() != seed) {
            currentSeed = Optional.of(seed);
            x = Optional.empty();
            z = Optional.empty();
        }
    }

    public static int getX(long seed) {
        StargateStructure.checkSeed(seed);
        if (x.isEmpty()) {
            Random random = new Random(seed + 2L);
            int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
            int xBound = (Integer)CommonGenerationConfig.stargate_generation_x_bound.get();
            int chunkX = xBound <= 0 ? xOffset : xOffset + random.nextInt(-xBound, xBound + 1);
            x = Optional.of(chunkX);
        }
        return x.get();
    }

    public static int getZ(long seed) {
        StargateStructure.checkSeed(seed);
        if (z.isEmpty()) {
            Random random = new Random(seed + 3L);
            int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
            int zBound = (Integer)CommonGenerationConfig.stargate_generation_z_bound.get();
            int chunkZ = zBound <= 0 ? zOffset : zOffset + random.nextInt(-zBound, zBound + 1);
            z = Optional.of(chunkZ);
        }
        return z.get();
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        long seed = context.f_226627_();
        return chunkpos.f_45578_ == StargateStructure.getX(seed) && chunkpos.f_45579_ == StargateStructure.getZ(seed);
    }

    @Override
    protected void generateBlockEntity(WorldGenLevel level, BlockPos startPos, RandomSource randomSource, StructureGenEntity generatedEntity) {
        super.generateBlockEntity(level, startPos, randomSource, generatedEntity);
        if (this.stargateModifiers != null && generatedEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)generatedEntity;
            this.stargateModifiers.modifyStargate(stargate);
        } else if (this.dhdModifiers != null && generatedEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)generatedEntity;
            this.dhdModifiers.modifyDHD(dhd);
        }
    }

    public static class StargateModifiers {
        private boolean displayID;
        private boolean upgraded;
        private boolean localPointOfOrigin;
        private boolean primary;
        private boolean isProtected;
        public static final Codec<StargateModifiers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("display_id").forGetter(modifiers -> Optional.ofNullable(modifiers.displayID)), (App)Codec.BOOL.optionalFieldOf("upgraded").forGetter(modifiers -> Optional.ofNullable(modifiers.upgraded)), (App)Codec.BOOL.optionalFieldOf("local_point_of_origin").forGetter(modifiers -> Optional.ofNullable(modifiers.localPointOfOrigin)), (App)Codec.BOOL.optionalFieldOf("primary").forGetter(modifiers -> Optional.ofNullable(modifiers.primary)), (App)Codec.BOOL.optionalFieldOf("protected").forGetter(modifiers -> Optional.ofNullable(modifiers.isProtected))).apply((Applicative)instance, StargateModifiers::new));

        public StargateModifiers(Optional<Boolean> displayID, Optional<Boolean> upgraded, Optional<Boolean> localPointOfOrigin, Optional<Boolean> primary, Optional<Boolean> isProtected) {
            this.displayID = displayID.orElse(false);
            this.upgraded = upgraded.orElse(false);
            this.localPointOfOrigin = localPointOfOrigin.orElse(false);
            this.primary = primary.orElse(false);
            this.isProtected = isProtected.orElse(false);
        }

        public void modifyStargate(AbstractStargateEntity stargate) {
            if (this.displayID) {
                stargate.displayID();
            }
            if (this.upgraded) {
                stargate.upgraded();
            }
            if (this.localPointOfOrigin) {
                stargate.localPointOfOrigin();
            }
            if (this.primary) {
                stargate.setPrimary();
            }
            if (this.isProtected) {
                stargate.setProtected(true);
            }
        }
    }

    public static class DHDModifiers {
        private boolean isProtected;
        public static final Codec<DHDModifiers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("protected").forGetter(modifiers -> Optional.ofNullable(modifiers.isProtected))).apply((Applicative)instance, DHDModifiers::new));

        public DHDModifiers(Optional<Boolean> isProtected) {
            this.isProtected = isProtected.orElse(false);
        }

        public void modifyDHD(AbstractDHDEntity dhd) {
            if (this.isProtected) {
                dhd.setProtected(true);
            }
        }
    }
}

