/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.station.GlobalStation;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlobalStation.class}, remap=false)
public abstract class MixinGlobalStation
implements ILimitedGlobalStation {
    private boolean limitEnabled;

    @Shadow
    @Nullable
    public abstract Train getNearestTrain();

    @Shadow
    @Nullable
    public abstract Train getImminentTrain();

    @Override
    public boolean isStationEnabled() {
        return !this.limitEnabled || this.getNearestTrain() == null;
    }

    @Override
    public Train getDisablingTrain() {
        if (!this.limitEnabled) {
            return null;
        }
        return this.getNearestTrain();
    }

    @Override
    public Train orDisablingTrain(Train before, Train except) {
        if (before == null || before == except) {
            before = this.getDisablingTrain();
        }
        return before;
    }

    @Override
    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
    }

    @Override
    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    @Inject(method={"read(Lnet/minecraft/nbt/CompoundTag;ZLcom/simibubi/create/content/trains/graph/DimensionPalette;)V"}, at={@At(value="TAIL")}, remap=true)
    private void readLimit(CompoundTag nbt, boolean migration, DimensionPalette dimensions, CallbackInfo ci) {
        this.limitEnabled = nbt.m_128471_("LimitEnabled");
    }

    @Inject(method={"read(Lnet/minecraft/network/FriendlyByteBuf;Lcom/simibubi/create/content/trains/graph/DimensionPalette;)V"}, at={@At(value="TAIL")}, remap=true)
    private void readNetLimit(FriendlyByteBuf buffer, DimensionPalette dimensions, CallbackInfo ci) {
        this.limitEnabled = buffer.readBoolean();
    }

    @Inject(method={"write(Lnet/minecraft/nbt/CompoundTag;Lcom/simibubi/create/content/trains/graph/DimensionPalette;)V"}, at={@At(value="TAIL")}, remap=true)
    private void writeLimit(CompoundTag nbt, DimensionPalette dimensions, CallbackInfo ci) {
        nbt.m_128379_("LimitEnabled", this.limitEnabled);
    }

    @Inject(method={"write(Lnet/minecraft/network/FriendlyByteBuf;Lcom/simibubi/create/content/trains/graph/DimensionPalette;)V"}, at={@At(value="TAIL")}, remap=true)
    private void writeNetLimit(FriendlyByteBuf buffer, DimensionPalette dimensions, CallbackInfo ci) {
        buffer.writeBoolean(this.limitEnabled);
    }
}

