/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.common.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tcintegrations.common.capabilities.CapabilityRegistry;

public class ArsElementalSet {
    private boolean air = false;
    private boolean aqua = false;
    private boolean earth = false;
    private boolean fire = false;

    public static Tag writeNBT(Capability<ArsElementalSet> capability, ArsElementalSet instance, Direction side) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("air", instance.hasAir());
        tag.m_128379_("aqua", instance.hasAqua());
        tag.m_128379_("earth", instance.hasEarth());
        tag.m_128379_("fire", instance.hasFire());
        return tag;
    }

    public static void readNBT(Capability<ArsElementalSet> capability, ArsElementalSet instance, Direction side, Tag nbt) {
        instance.setAir(((CompoundTag)nbt).m_128471_("air"));
        instance.setAqua(((CompoundTag)nbt).m_128471_("aqua"));
        instance.setEarth(((CompoundTag)nbt).m_128471_("earth"));
        instance.setFire(((CompoundTag)nbt).m_128471_("fire"));
    }

    public void setAir(boolean air) {
        this.air = air;
    }

    public boolean hasAir() {
        return this.air;
    }

    public void setAqua(boolean aqua) {
        this.aqua = aqua;
    }

    public boolean hasAqua() {
        return this.aqua;
    }

    public void setEarth(boolean earth) {
        this.earth = earth;
    }

    public boolean hasEarth() {
        return this.earth;
    }

    public void setFire(boolean fire) {
        this.fire = fire;
    }

    public boolean hasFire() {
        return this.fire;
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @NotNull
        private final ArsElementalSet instance = new ArsElementalSet();
        private final LazyOptional<ArsElementalSet> handler = LazyOptional.of(this::getInstance);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == null) {
                return LazyOptional.empty();
            }
            return CapabilityRegistry.ARS_ELEMENTAL_SET_CAPABILITY.orEmpty(cap, this.handler);
        }

        @NotNull
        public ArsElementalSet getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return ArsElementalSet.writeNBT(CapabilityRegistry.ARS_ELEMENTAL_SET_CAPABILITY, this.instance, null);
        }

        public void deserializeNBT(Tag nbt) {
            ArsElementalSet.readNBT(CapabilityRegistry.ARS_ELEMENTAL_SET_CAPABILITY, this.instance, null, nbt);
        }
    }
}

