/*
 * Decompiled with CFR 0.152.
 */
package voltaic;

import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import voltaic.api.gas.Gas;
import voltaic.client.VoltaicClientRegister;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.condition.ConfigCondition;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.client.PacketResetGuidebookPages;
import voltaic.common.reloadlistener.RadiationShieldingRegister;
import voltaic.common.reloadlistener.RadioactiveBlockRegister;
import voltaic.common.reloadlistener.RadioactiveFluidRegister;
import voltaic.common.reloadlistener.RadioactiveGasRegister;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.common.settings.VoltaicConstants;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.configuration.ConfigurationHandler;
import voltaic.registers.UnifiedVoltaicRegister;
import voltaic.registers.VoltaicGases;
import voltaic.registers.VoltaicRegistries;

@Mod(value="voltaic")
@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Voltaic {
    public static Logger LOGGER = LogManager.getLogger((String)"voltaic");
    public static final Random RANDOM = new Random();
    public static final String ID = "voltaic";
    public static final String NAME = "Voltaic";
    public static final String MEKANISM_ID = "mekanism";
    private static final String ELECTRODYNAMICS_MOD_ID = "electrodynamics";
    @Nullable
    private static Boolean ELECTRODYNAMICS_LOADED = null;

    public Voltaic() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ELECTRODYNAMICS_LOADED = ModList.get().isLoaded(ELECTRODYNAMICS_MOD_ID);
        ConfigurationHandler.registerConfig(VoltaicConstants.class);
        VoltaicBlockStates.init();
        UnifiedVoltaicRegister.register(bus);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(Voltaic.getGuidebookListener());
        NetworkHandler.init();
        VoltaicTags.init();
        RadioactiveItemRegister.INSTANCE = new RadioactiveItemRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        RadioactiveFluidRegister.INSTANCE = new RadioactiveFluidRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        RadioactiveGasRegister.INSTANCE = new RadioactiveGasRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        RadiationShieldingRegister.INSTANCE = new RadiationShieldingRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        RadioactiveBlockRegister.INSTANCE = new RadioactiveBlockRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        event.enqueueWork(() -> VoltaicRegistries.gasRegistry().forEach(gas -> VoltaicGases.MAPPED_GASSES.put(gas.getCondensedFluid(), (Gas)gas)));
    }

    @SubscribeEvent
    public static void registerConditions(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)ConfigCondition.Serializer.INSTANCE);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> VoltaicClientRegister.setup());
    }

    private static Consumer<OnDatapackSyncEvent> getGuidebookListener() {
        return event -> {
            ServerPlayer player = event.getPlayer();
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            NetworkHandler.CHANNEL.send(target, (Object)new PacketResetGuidebookPages());
        };
    }

    public static final ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }

    public static final ResourceLocation vanillarl(String path) {
        return new ResourceLocation(path);
    }

    public static final ResourceLocation forgerl(String path) {
        return new ResourceLocation("forge", path);
    }

    public static final Boolean isElectroLoaded() {
        return ELECTRODYNAMICS_LOADED;
    }
}

