/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.multiblock.subnodebased;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicTiles;

public class TileMultiSubnode
extends GenericTile {
    public final SingleProperty<BlockPos> parentPos = this.property(new SingleProperty<BlockPos>(PropertyTypes.BLOCK_POS, "nodePos", BlockEntityUtils.OUT_OF_REACH));
    public final SingleProperty<Integer> nodeIndex = this.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "nodeIndex", Integer.valueOf(0)));
    public VoxelShape shapeCache;

    public TileMultiSubnode(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)VoltaicTiles.TILE_MULTI.get(), worldPosition, blockState);
        this.addComponent(new ComponentPacketHandler(this));
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            return node.getSubnodeCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public void setData(BlockPos parentPos, int subnodeIndex) {
        this.parentPos.setValue(parentPos);
        this.nodeIndex.setValue(subnodeIndex);
        this.m_6596_();
    }

    public VoxelShape getShape() {
        if (this.shapeCache != null) {
            return this.shapeCache;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            this.shapeCache = node.getSubNodes().getSubnodes(node.getFacingDirection())[(Integer)this.nodeIndex.getValue()].getShape(node.getFacingDirection());
            return this.shapeCache;
        }
        return Shapes.m_83144_();
    }

    @Override
    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            node.onSubnodeNeighborChange(this, neighbor, blockStateTrigger);
        }
    }

    @Override
    public InteractionResult use(Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            return node.onSubnodeUse(player, handIn, hit, this);
        }
        return super.use(player, handIn, hit);
    }

    @Override
    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            node.onSubnodePlace(this, oldState, isMoving);
        }
    }

    @Override
    public int getComparatorSignal() {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            return node.getSubdnodeComparatorSignal(this);
        }
        return 0;
    }

    @Override
    public void onBlockDestroyed() {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile node = (IMultiblockParentTile)blockEntity;
            node.onSubnodeDestroyed(this);
        }
        super.onBlockDestroyed();
    }

    @Override
    public int getDirectSignal(Direction dir) {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile parent = (IMultiblockParentTile)blockEntity;
            return parent.getDirectSignal(this, dir);
        }
        return 0;
    }

    @Override
    public int getSignal(Direction dir) {
        BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)this.parentPos.getValue());
        if (blockEntity instanceof IMultiblockParentTile) {
            IMultiblockParentTile parent = (IMultiblockParentTile)blockEntity;
            return parent.getSignal(this, dir);
        }
        return 0;
    }
}

