/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluid2fluid;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.codec.StreamCodec;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.fluid2fluid.Fluid2FluidRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class Fluid2FluidRecipeSerializer<T extends Fluid2FluidRecipe>
extends VoltaicRecipeSerializer<T> {
    private final Fluid2FluidRecipe.Factory<T> factory;

    public Fluid2FluidRecipeSerializer(Fluid2FluidRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, FluidIngredient.LIST_STREAM_CODEC, Fluid2FluidRecipe::getFluidIngredients, StreamCodec.FLUID_STACK, Fluid2FluidRecipe::getFluidRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<FluidIngredient> inputs = Fluid2FluidRecipeSerializer.getFluidIngredients(recipeId, recipeJson);
        FluidStack output = Fluid2FluidRecipeSerializer.getFluidOutput(recipeId, recipeJson);
        double experience = Fluid2FluidRecipeSerializer.getExperience(recipeJson);
        int ticks = Fluid2FluidRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = Fluid2FluidRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = Fluid2FluidRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = Fluid2FluidRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = Fluid2FluidRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

