/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.item2item;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import voltaic.api.codec.StreamCodec;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class Item2ItemRecipeSerializer<T extends Item2ItemRecipe>
extends VoltaicRecipeSerializer<T> {
    private final Item2ItemRecipe.Factory<T> factory;

    public Item2ItemRecipeSerializer(Item2ItemRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, CountableIngredient.LIST_STREAM_CODEC, Item2ItemRecipe::getCountedIngredients, StreamCodec.ITEM_STACK, Item2ItemRecipe::getItemRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<CountableIngredient> inputs = Item2ItemRecipeSerializer.getItemIngredients(recipeId, recipeJson);
        ItemStack output = Item2ItemRecipeSerializer.getItemOutput(recipeId, recipeJson);
        double experience = Item2ItemRecipeSerializer.getExperience(recipeJson);
        int ticks = Item2ItemRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = Item2ItemRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = Item2ItemRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = Item2ItemRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = Item2ItemRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

