/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.utils.label.types;

import net.minecraft.network.chat.Component;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.label.AbstractLabelWrapper;
import voltaic.prefab.utilities.math.Color;

public class BiproductPercentWrapperElectroRecipe
extends AbstractLabelWrapper {
    private final BiproductType type;
    private final int index;

    public BiproductPercentWrapperElectroRecipe(int xPos, int yPos, BiproductType type, int index) {
        super(Color.JEI_TEXT_GRAY, yPos, xPos, false);
        this.type = type;
        this.index = index;
    }

    @Override
    public Component getComponent(AbstractRecipeCategory<?> category, Object recipe) {
        switch (this.type) {
            case ITEM: {
                VoltaicRecipe electro = (VoltaicRecipe)recipe;
                if (!electro.hasItemBiproducts() || this.index >= electro.getItemBiproducts().size()) break;
                ProbableItem item = electro.getItemBiproducts().get(this.index);
                return ChatFormatter.getChatDisplayShort(item.getChance() * 100.0, DisplayUnits.PERCENTAGE);
            }
            case FLUID: {
                VoltaicRecipe electro = (VoltaicRecipe)recipe;
                if (!electro.hasFluidBiproducts() || this.index >= electro.getFluidBiproducts().size()) break;
                ProbableFluid item = electro.getFluidBiproducts().get(this.index);
                return ChatFormatter.getChatDisplayShort(item.getChance() * 100.0, DisplayUnits.PERCENTAGE);
            }
            case GAS: {
                VoltaicRecipe electro = (VoltaicRecipe)recipe;
                if (!electro.hasGasBiproducts() || this.index >= electro.getFluidBiproducts().size()) break;
                ProbableGas item = electro.getGasBiproducts().get(this.index);
                return ChatFormatter.getChatDisplayShort(item.getChance() * 100.0, DisplayUnits.PERCENTAGE);
            }
        }
        return Component.m_237119_();
    }

    public static enum BiproductType {
        ITEM,
        FLUID,
        GAS;

    }
}

