/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.datagen.client.VoltaicBlockStateProvider;
import voltaic.datagen.client.VoltaicItemModelsProvider;
import voltaic.datagen.client.VoltaicLangKeyProvider;
import voltaic.datagen.client.VoltaicSoundProvider;
import voltaic.datagen.server.VoltaicAdvancementProvider;
import voltaic.datagen.server.VoltaicRadiationShieldingProvider;
import voltaic.datagen.server.recipe.VoltaicRecipeProvider;
import voltaic.datagen.server.tags.VoltaicTagsProvider;
import voltaic.datagen.utils.client.BaseLangKeyProvider;
import voltaic.registers.VoltaicDamageTypes;

@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            DatapackBuiltinEntriesProvider datapacks = new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().m_254916_(Registries.f_268580_, VoltaicDamageTypes::registerTypes), Set.of("voltaic"));
            generator.addProvider(true, (DataProvider)datapacks);
            VoltaicTagsProvider.addTagProviders(generator, output, datapacks.getRegistryProvider(), helper);
            generator.addProvider(true, (DataProvider)new VoltaicRecipeProvider(output));
            generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(output, event.getLookupProvider(), helper, List.of(new VoltaicAdvancementProvider())));
            generator.addProvider(true, (DataProvider)new VoltaicRadiationShieldingProvider(output));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new VoltaicBlockStateProvider(output, helper));
            generator.addProvider(true, (DataProvider)new VoltaicItemModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new VoltaicLangKeyProvider(output, BaseLangKeyProvider.Locale.EN_US));
            generator.addProvider(true, (DataProvider)new VoltaicSoundProvider(output, helper));
        }
    }
}

