/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.types;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NbtOps;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.properties.types.IPropertyType;

public class SinglePropertyType<TYPE, BUFFERTYPE>
implements IPropertyType<TYPE, BUFFERTYPE> {
    private final BiPredicate<TYPE, TYPE> comparison;
    private final Consumer<IPropertyType.TagWriter<TYPE>> writeToNbt;
    private final Function<IPropertyType.TagReader<TYPE>, TYPE> readFromNbt;
    private final StreamCodec<BUFFERTYPE, TYPE> packetCodec;

    public SinglePropertyType(@Nonnull BiPredicate<TYPE, TYPE> comparison, StreamCodec<BUFFERTYPE, TYPE> packetCodec, Codec<TYPE> nbtCodec) {
        this(comparison, packetCodec, writer -> nbtCodec.encode(writer.prop().getValue(), (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).result().ifPresent(tag -> writer.tag().m_128365_(writer.prop().getName(), tag)), reader -> {
            DataResult result = nbtCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)reader.tag().m_128423_(reader.prop().getName()));
            return result.result().isPresent() ? ((Pair)result.result().get()).getFirst() : reader.prop().getValue();
        });
    }

    public SinglePropertyType(@Nonnull BiPredicate<TYPE, TYPE> comparison, StreamCodec<BUFFERTYPE, TYPE> packetCodec, Consumer<IPropertyType.TagWriter<TYPE>> tagWriter, Function<IPropertyType.TagReader<TYPE>, TYPE> tagReader) {
        this.comparison = comparison;
        this.packetCodec = packetCodec;
        this.writeToNbt = tagWriter;
        this.readFromNbt = tagReader;
    }

    @Override
    public StreamCodec<BUFFERTYPE, TYPE> getPacketCodec() {
        return this.packetCodec;
    }

    @Override
    public void writeToTag(IPropertyType.TagWriter<TYPE> writer) {
        this.writeToNbt.accept(writer);
    }

    @Override
    public TYPE readFromTag(IPropertyType.TagReader<TYPE> reader) {
        return this.readFromNbt.apply(reader);
    }

    @Override
    public boolean isEqual(TYPE currentValue, TYPE newValue) {
        return this.comparison.test(currentValue, newValue);
    }
}

