/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.editbox;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.utilities.math.Color;

@OnlyIn(value=Dist.CLIENT)
public class ScreenComponentEditBox
extends ScreenComponentGeneric {
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/textinputbar.png");
    public static final char[] POSITIVE_DECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
    public static final char[] DECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '-'};
    public static final char[] POSITIVE_INTEGER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] INTEGER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    public static final Color DEFAULT_TEXT_COLOR = new Color(224, 224, 224, 0);
    private final Font font;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private Color textColor = DEFAULT_TEXT_COLOR;
    private Color textColorUneditable = new Color(112, 112, 112, 0);
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (p_94147_, p_94148_) -> FormattedCharSequence.m_13714_((String)p_94147_, (Style)Style.f_131099_);

    public ScreenComponentEditBox(int x, int y, int width, int height, Font font) {
        super(x, y, width, height);
        this.texture = TextInputTextures.TEXT_INPUT_BASE;
        this.font = font;
    }

    public ScreenComponentEditBox setResponder(Consumer<String> responder) {
        this.responder = responder;
        return this;
    }

    public ScreenComponentEditBox setFormatter(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.formatter = textFormatter;
        return this;
    }

    public ScreenComponentEditBox setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(min, max);
    }

    public ScreenComponentEditBox setFilter(Predicate<String> validator) {
        this.filter = validator;
        return this;
    }

    public ScreenComponentEditBox setFilter(char[] validChars) {
        return this.setFilter(ScreenComponentEditBox.getValidator(validChars));
    }

    public void insertText(String textToWrite) {
        String updated;
        String filtered;
        int filteredLength;
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        int length = this.maxLength - this.value.length() - (min - max);
        if (length < (filteredLength = (filtered = SharedConstants.m_136190_((String)textToWrite)).length())) {
            filtered = filtered.substring(0, length);
            filteredLength = length;
        }
        if (this.filter.test(updated = new StringBuilder(this.value).replace(min, max, filtered).toString())) {
            this.value = updated;
            this.setCursorPosition(min + filteredLength);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int count) {
        if (Screen.m_96637_()) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(num) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String updated;
                int max;
                int cursorPos = this.getCursorPos(num);
                int min = Math.min(cursorPos, this.cursorPos);
                if (min != (max = Math.max(cursorPos, this.cursorPos)) && this.filter.test(updated = new StringBuilder(this.value).delete(min, max).toString())) {
                    this.value = updated;
                    this.moveCursorTo(min);
                }
            }
        }
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private int getWordPosition(int numOfWords, int position) {
        return this.getWordPosition(numOfWords, position, true);
    }

    private int getWordPosition(int numOfWords, int position, boolean skipSpaces) {
        int originalPos = position;
        boolean noWords = numOfWords < 0;
        int absNoWords = Math.abs(numOfWords);
        for (int i = 0; i < absNoWords; ++i) {
            if (!noWords) {
                int lengthOfText = this.value.length();
                if ((originalPos = this.value.indexOf(32, originalPos)) == -1) {
                    originalPos = lengthOfText;
                    continue;
                }
                while (skipSpaces && originalPos < lengthOfText && this.value.charAt(originalPos) == ' ') {
                    ++originalPos;
                }
                continue;
            }
            while (skipSpaces && originalPos > 0 && this.value.charAt(originalPos - 1) == ' ') {
                --originalPos;
            }
            while (originalPos > 0 && this.value.charAt(originalPos - 1) != ' ') {
                --originalPos;
            }
        }
        return originalPos;
    }

    public void moveCursor(int delta) {
        this.moveCursorTo(this.getCursorPos(delta));
    }

    private int getCursorPos(int delta) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public void moveCursorTo(int pos) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = Mth.m_14045_((int)pos, (int)0, (int)this.value.length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable) {
                this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (!SharedConstants.m_136188_((char)codePoint)) {
            return false;
        }
        if (this.isEditable) {
            this.insertText(Character.toString(codePoint));
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        boolean mouseOver = this.m_5953_(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocus(mouseOver);
        }
        if (this.m_93696_() && mouseOver && button == 0) {
            int exitBoxXPos = Mth.m_14107_((double)mouseX) - this.xLocation - (int)this.gui.getGuiWidth() - 4;
            String text = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.m_92834_(text, exitBoxXPos).length() + this.displayPos);
            return true;
        }
        return false;
    }

    public ScreenComponentEditBox setFocus(boolean isFocused) {
        this.m_93692_(isFocused);
        return this;
    }

    public void tick() {
        ++this.frame;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        ScreenComponentEditBox.drawExpandedBox(graphics, this.texture.getLocation(), this.xLocation + guiWidth, this.yLocation + guiHeight, this.width, this.height);
        Color textColor = this.isEditable ? this.textColor : this.textColorUneditable;
        int highlightedSize = this.cursorPos - this.displayPos;
        int highlightedLength = this.highlightPos - this.displayPos;
        String displayedText = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean isHighlightedValid = highlightedSize >= 0 && highlightedSize <= displayedText.length();
        boolean blinkCursor = this.m_93696_() && this.frame / 6 % 2 == 0 && isHighlightedValid;
        int textStartX = this.xLocation + guiWidth + 4;
        int textStartY = this.yLocation + guiHeight + (this.height - 8) / 2;
        int textStartPre = textStartX;
        if (highlightedLength > displayedText.length()) {
            highlightedLength = displayedText.length();
        }
        if (!displayedText.isEmpty()) {
            String highlightedText = isHighlightedValid ? displayedText.substring(0, highlightedSize) : displayedText;
            textStartPre = graphics.m_280648_(this.font, this.formatter.apply(highlightedText, this.displayPos), textStartX, textStartY, textColor.color());
        }
        boolean isCursorPastLength = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int textStartPreCopy = textStartPre;
        if (!isHighlightedValid) {
            textStartPreCopy = highlightedSize > 0 ? textStartX + this.width : textStartX;
        } else if (isCursorPastLength) {
            textStartPreCopy = textStartPre - 1;
            --textStartPre;
        }
        if (!displayedText.isEmpty() && isHighlightedValid && highlightedSize < displayedText.length()) {
            graphics.m_280648_(this.font, this.formatter.apply(displayedText.substring(highlightedSize), this.cursorPos), textStartPre, textStartY, textColor.color());
        }
        if (!isCursorPastLength && this.suggestion != null) {
            graphics.m_280488_(this.font, this.suggestion, textStartPreCopy - 1, textStartY, -8355712);
        }
        if (blinkCursor) {
            if (isCursorPastLength) {
                graphics.m_285944_(RenderType.m_286086_(), textStartPreCopy, textStartY - 1, textStartPreCopy + 1, textStartY + 1 + 9, -3092272);
            } else {
                graphics.m_280488_(this.font, "_", textStartPreCopy, textStartY, textColor.color());
            }
        }
        if (highlightedLength != highlightedSize) {
            int l1 = textStartX + this.font.m_92895_(displayedText.substring(0, highlightedLength));
            this.renderHighlight(graphics, textStartPreCopy, textStartY - 1, l1 - 1, textStartY + 1 + 9, guiWidth, guiHeight);
        }
    }

    private void renderHighlight(GuiGraphics graphics, int pMinX, int pMinY, int pMaxX, int pMaxY, int guiWidth, int guiHeight) {
        if (pMinX < pMaxX) {
            int i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            int j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        if (pMaxX > this.xLocation + this.width + guiWidth) {
            pMaxX = this.yLocation + this.width;
        }
        if (pMinX > this.xLocation + this.width + guiWidth) {
            pMinX = this.xLocation + this.width;
        }
        graphics.m_285944_(RenderType.m_285783_(), pMinX, pMinY, pMaxX, pMaxY, -16776961);
    }

    public ScreenComponentEditBox setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
        return this;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public ScreenComponentEditBox setTextColor(Color pColor) {
        this.textColor = pColor;
        return this;
    }

    public ScreenComponentEditBox setTextColorUneditable(Color pColor) {
        this.textColorUneditable = pColor;
        return this;
    }

    protected void onFocusedChanged(boolean pFocused) {
        if (pFocused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean pEnabled) {
        this.isEditable = pEnabled;
    }

    public int getInnerWidth() {
        return this.width - 8;
    }

    public void setHighlightPos(int position) {
        int length = this.value.length();
        this.highlightPos = Mth.m_14045_((int)position, (int)0, (int)length);
        if (this.font != null) {
            if (this.displayPos > length) {
                this.displayPos = length;
            }
            int innerWidth = this.getInnerWidth();
            String text = this.font.m_92834_(this.value.substring(this.displayPos), innerWidth);
            int textStartX = text.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.m_92837_(this.value, innerWidth, true).length();
            }
            if (this.highlightPos > textStartX) {
                this.displayPos += this.highlightPos - textStartX;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)length);
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int getScreenX(int charNum) {
        return (int)(charNum > this.value.length() ? (double)this.xLocation + this.gui.getGuiWidth() : (double)this.xLocation + this.gui.getGuiWidth() + (double)this.font.m_92895_(this.value.substring(0, charNum)));
    }

    public void setX(int xPos) {
        this.xLocation = xPos;
    }

    public static void drawExpandedBox(GuiGraphics graphics, ResourceLocation texture, int x, int y, int boxWidth, int boxHeight) {
        if (boxWidth < 18) {
            if (boxHeight < 18) {
                graphics.m_280411_(texture, x, y, boxWidth, boxHeight, 0.0f, 0.0f, boxWidth, boxHeight, boxWidth, boxHeight);
            } else {
                graphics.m_280411_(texture, x, y, boxWidth, 7, 0.0f, 0.0f, boxWidth, 7, boxWidth, 18);
                int sectionHeight = boxHeight - 14;
                int heightIterations = sectionHeight / 4;
                int remainderHeight = sectionHeight % 4;
                int heightOffset = 7;
                for (int i = 0; i < heightIterations; ++i) {
                    graphics.m_280411_(texture, x, y + heightOffset, boxWidth, 4, 0.0f, 7.0f, boxWidth, 4, boxWidth, 18);
                    heightOffset += 4;
                }
                graphics.m_280411_(texture, x, y + heightOffset, boxWidth, remainderHeight, 0.0f, 7.0f, boxWidth, remainderHeight, boxWidth, 18);
                graphics.m_280411_(texture, x, y + boxHeight - 7, boxWidth, 7, 0.0f, 11.0f, boxWidth, 7, boxWidth, 18);
            }
        } else if (boxHeight < 18) {
            graphics.m_280411_(texture, x, y, 7, boxHeight, 0.0f, 0.0f, 7, boxHeight, 18, boxHeight);
            int sectionWidth = boxWidth - 14;
            int widthIterations = sectionWidth / 4;
            int remainderWidth = sectionWidth % 4;
            int widthOffset = 7;
            for (int i = 0; i < widthIterations; ++i) {
                graphics.m_280411_(texture, x + widthOffset, y, 4, boxHeight, 7.0f, 0.0f, 4, boxHeight, 18, boxHeight);
                widthOffset += 4;
            }
            graphics.m_280411_(texture, x + widthOffset, y, remainderWidth, boxHeight, 7.0f, 0.0f, remainderWidth, boxHeight, 18, boxHeight);
            graphics.m_280411_(texture, x + boxWidth - 7, y, 7, boxHeight, 11.0f, 0.0f, 7, boxHeight, 18, boxHeight);
        } else {
            int i;
            int squareWidth = boxWidth - 10;
            int squareWidthIterations = squareWidth / 8;
            int remainderSquareWidth = squareWidth % 8;
            int squareHeight = boxHeight - 10;
            int squareHeightIterations = squareHeight / 8;
            int remainderSquareHeight = squareHeight % 8;
            int heightOffset = 5;
            int widthOffset = 5;
            for (int i2 = 0; i2 <= squareHeightIterations; ++i2) {
                int height = i2 == squareHeightIterations ? remainderSquareHeight : 8;
                for (int j = 0; j < squareWidthIterations; ++j) {
                    ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 5, 5, 8, height);
                    widthOffset += 8;
                }
                ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 5, 5, remainderSquareWidth, height);
                widthOffset = 5;
                heightOffset += 8;
            }
            ScreenComponentEditBox.draw(graphics, texture, x, y, 0, 0, 0, 0, 8, 8);
            int stripWidth = boxWidth - 14;
            int stripWidthIterations = stripWidth / 4;
            int remainderStripWidth = stripWidth % 4;
            int stripHeight = boxHeight - 14;
            int stripHeightIterations = stripHeight / 4;
            int remainderStripHeight = stripHeight % 4;
            widthOffset = 7;
            for (i = 0; i < stripWidthIterations; ++i) {
                ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, 0, 7, 0, 4, 5);
                widthOffset += 4;
            }
            ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, 0, 7, 0, remainderStripWidth, 5);
            ScreenComponentEditBox.draw(graphics, texture, x, y, boxWidth - 8, 0, 10, 0, 8, 8);
            heightOffset = 7;
            for (i = 0; i < stripHeightIterations; ++i) {
                ScreenComponentEditBox.draw(graphics, texture, x, y, 0, heightOffset, 0, 7, 5, 4);
                heightOffset += 4;
            }
            ScreenComponentEditBox.draw(graphics, texture, x, y, 0, heightOffset, 0, 5, 5, remainderStripHeight);
            heightOffset = 7;
            widthOffset = boxWidth - 5;
            for (i = 0; i < stripHeightIterations; ++i) {
                ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 13, 7, 5, 4);
                heightOffset += 4;
            }
            ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 13, 7, 5, remainderStripHeight);
            ScreenComponentEditBox.draw(graphics, texture, x, y, 0, boxHeight - 8, 0, 10, 8, 8);
            heightOffset = boxHeight - 5;
            widthOffset = 7;
            for (i = 0; i < stripWidthIterations; ++i) {
                ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 7, 13, 4, 5);
                widthOffset += 4;
            }
            ScreenComponentEditBox.draw(graphics, texture, x, y, widthOffset, heightOffset, 7, 13, remainderStripWidth, 5);
            ScreenComponentEditBox.draw(graphics, texture, x, y, boxWidth - 8, boxHeight - 8, 10, 10, 8, 8);
        }
    }

    private static void draw(GuiGraphics graphics, ResourceLocation texture, int x, int y, int widthOffset, int heightOffset, int textXOffset, int textYOffset, int width, int height) {
        graphics.m_280411_(texture, x + widthOffset, y + heightOffset, width, height, (float)textXOffset, (float)textYOffset, width, height, 18, 18);
    }

    public static Predicate<String> getValidator(char[] validChars) {
        return string -> {
            if (string.isEmpty()) {
                return true;
            }
            boolean flag = false;
            for (char character : string.toCharArray()) {
                for (char valid : validChars) {
                    if (valid != character) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return false;
                }
                flag = false;
            }
            return true;
        };
    }

    public static enum TextInputTextures implements ITexture
    {
        TEXT_INPUT_BASE(0, 0, 0, 0, 16, 16, TEXTURE);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private TextInputTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

