/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.guitab;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.api.screen.component.TextPropertySupplier;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.utils.AbstractScreenComponentInfo;

public class ScreenComponentGuiTab
extends AbstractScreenComponentInfo {
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/screentabs.png");
    private final ITexture iconType;

    public ScreenComponentGuiTab(ITexture texture, ITexture icon, @Nonnull TextPropertySupplier infoHandler, int x, int y) {
        super(texture, infoHandler, x, y);
        this.iconType = icon;
    }

    @Override
    protected List<? extends FormattedCharSequence> getInfo(List<? extends FormattedCharSequence> list) {
        return this.infoHandler.getInfo();
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        if (this.iconType == ScreenComponentSlot.IconType.NONE) {
            return;
        }
        int slotXOffset = (this.texture.imageWidth() - this.iconType.imageWidth()) / 2;
        int slotYOffset = (this.texture.imageHeight() - this.iconType.imageHeight()) / 2;
        graphics.m_280163_(this.iconType.getLocation(), guiWidth + this.xLocation + slotXOffset, guiHeight + this.yLocation + slotYOffset, (float)this.iconType.textureU(), (float)this.iconType.textureV(), this.iconType.textureWidth(), this.iconType.textureHeight(), this.iconType.imageWidth(), this.iconType.imageHeight());
    }

    public static enum GuiInfoTabTextures implements ITexture
    {
        REGULAR(26, 26, 0, 0, 26, 26, "tab_regular"),
        REGULAR_RIGHT(26, 26, 0, 0, 26, 26, "tab_regular_right");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private GuiInfoTabTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/guitab/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

