/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class ComponentUpgradeHandler
implements IComponent {
    public static final double BASIC_SPEED_BOOST = 1.5;
    public static final double BASIC_SPEED_POWER = 1.5;
    public static final double ADVANCED_SPEED_BOOST = 2.25;
    public static final double ADVANCED_SPEED_POWER = 2.25;
    public static final double SOLAR_CELL_MULT = 2.25;
    public static final double STATOR_MULT = 2.25;
    private GenericTile holder;
    private SingleProperty<Double> powerUsageMultiplier;
    private SingleProperty<Boolean> hasEjectorUpgrade;
    private SingleProperty<Boolean> hasInjectorUpgrade;
    private SingleProperty<Double> powerGenerationMultiplier;
    private SingleProperty<Integer> unbreakingLevel;
    private SingleProperty<Integer> fortuneLevel;
    private SingleProperty<Integer> silkTouchLevel;
    private SingleProperty<Boolean> hasExperienceUpgrade;
    private SingleProperty<Integer> rangeLevel;

    public ComponentUpgradeHandler(GenericTile holder) {
        this.holder = holder;
        this.powerUsageMultiplier = holder.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "powerusageupgradecomponent", Double.valueOf(1.0)));
        this.hasEjectorUpgrade = holder.property(new SingleProperty<Boolean>(PropertyTypes.BOOLEAN, "hasejectorupgradecomponent", Boolean.valueOf(false)));
        this.hasInjectorUpgrade = holder.property(new SingleProperty<Boolean>(PropertyTypes.BOOLEAN, "hasinjectorupgradecomponent", Boolean.valueOf(false)));
        this.powerGenerationMultiplier = holder.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "powergenupgradecomponent", Double.valueOf(1.0)));
        this.unbreakingLevel = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "unbreakinglevelupgradecomponent", Integer.valueOf(0)));
        this.silkTouchLevel = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "silktouchlevelupgradecomponent", Integer.valueOf(0)));
        this.fortuneLevel = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "fortunelevelupgradecomponent", Integer.valueOf(0)));
        this.hasExperienceUpgrade = holder.property(new SingleProperty<Boolean>(PropertyTypes.BOOLEAN, "experienceupgradecomponent", Boolean.valueOf(false)));
        this.rangeLevel = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "rangelevelupgradecomponent", Integer.valueOf(1)));
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public IComponentType getType() {
        return IComponentType.UpgradeHandler;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt) {
    }

    @Override
    public void saveToNBT(CompoundTag nbt) {
    }

    public void serverTick(ComponentTickable tick) {
        if (!((Boolean)this.hasEjectorUpgrade.getValue()).booleanValue() && !((Boolean)this.hasInjectorUpgrade.getValue()).booleanValue()) {
            return;
        }
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        for (ItemStack stack : inv.getUpgradeContents()) {
            ItemUpgrade upgrade = (ItemUpgrade)stack.m_41720_();
            if (upgrade.subtype == SubtypeItemUpgrade.itemoutput && !((Boolean)this.hasEjectorUpgrade.getValue()).booleanValue()) continue;
        }
    }

    public void onInventoryChange(int slot, ComponentInventory inv) {
    }
}

