/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.GenericTile;

public class BlockEntityUtils {
    public static final BlockPos OUT_OF_REACH = new BlockPos(0, -1000, 0);
    public static final int[][] RELATIVE_MATRIX = new int[][]{{3, 2, 1, 0, 5, 4}, {4, 5, 0, 1, 2, 3}, {0, 1, 2, 3, 4, 5}, {0, 1, 3, 2, 5, 4}, {0, 1, 4, 5, 3, 2}, {0, 1, 5, 4, 2, 3}};

    public static Direction getRelativeSide(Direction facingDirection, Direction relativeDirection) {
        if (facingDirection == null || relativeDirection == null) {
            return Direction.UP;
        }
        return Direction.values()[RELATIVE_MATRIX[facingDirection.ordinal()][relativeDirection.ordinal()]];
    }

    public static void updateLit(GenericTile tile, Boolean value) {
        Level world = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        if (tile.m_58900_().m_61138_((Property)VoltaicBlockStates.LIT)) {
            world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)value));
        }
    }

    public static boolean isLit(GenericTile tile) {
        if (tile.m_58900_().m_61138_((Property)VoltaicBlockStates.LIT)) {
            return (Boolean)tile.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT);
        }
        return false;
    }

    public static Direction directionFromPos(BlockPos thisPos, BlockPos otherPos) {
        return Direction.m_122378_((int)(otherPos.m_123341_() - thisPos.m_123341_()), (int)(otherPos.m_123342_() - thisPos.m_123342_()), (int)(otherPos.m_123343_() - thisPos.m_123343_()));
    }

    public static enum MachineDirection {
        BOTTOM(Direction.DOWN),
        TOP(Direction.UP),
        FRONT(Direction.NORTH),
        BACK(Direction.SOUTH),
        LEFT(Direction.WEST),
        RIGHT(Direction.EAST);

        public final Direction mappedDir;

        private MachineDirection(Direction mappedDir) {
            this.mappedDir = mappedDir;
        }

        public static Direction[] toDirectionArray(MachineDirection ... machineDirections) {
            Direction[] dirs = new Direction[machineDirections.length];
            for (int i = 0; i < machineDirections.length; ++i) {
                dirs[i] = machineDirections[i].mappedDir;
            }
            return dirs;
        }

        public static MachineDirection fromDirection(Direction dir) {
            return MachineDirection.values()[dir.ordinal()];
        }
    }
}

