/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities.object;

import com.electronwill.nightconfig.core.conversion.InvalidValueException;
import voltaic.prefab.properties.variant.SingleProperty;

public class TargetValue {
    private double val;
    private double target;
    private double acceleration;

    public double getValue() {
        return this.val;
    }

    public void setValue(double val) {
        this.val = val;
    }

    public TargetValue flush(double target, double acceleration) {
        if (acceleration < 0.0) {
            throw new InvalidValueException("Negative acceleration is not supported");
        }
        this.target = target;
        this.acceleration = this.getValue() < target && acceleration > 1.0 ? acceleration : 1.0 / acceleration;
        boolean aimsUp = this.acceleration > 1.0;
        double valAcc = this.getValue() * this.acceleration;
        this.setValue(aimsUp ? (valAcc > target ? target : valAcc) : (valAcc < target ? target : valAcc));
        return this;
    }

    public TargetValue rangeParameterize(double starttarget, double endtarget, double currentTarget, double value, int ticks) {
        this.setValue(value);
        this.target = currentTarget;
        this.acceleration = Math.pow(endtarget / starttarget, 1.0 / (double)ticks);
        return this;
    }

    public TargetValue flush() {
        return this.flush(this.target, this.acceleration);
    }

    public static class PropertyTargetValue
    extends TargetValue {
        private final SingleProperty<Double> valueProperty;

        public PropertyTargetValue(SingleProperty<Double> val) {
            this.valueProperty = val;
        }

        @Override
        public double getValue() {
            return (Double)this.valueProperty.getValue();
        }

        @Override
        public void setValue(double val) {
            this.valueProperty.setValue(val);
        }
    }
}

