/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.client.utils.SoundUtils;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.vehicles.LanderMenu;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Lander
extends Vehicle {
    private float speed;
    private float angle;
    public boolean startedRocketSound;

    public Lander(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.speed = compound.m_128457_("Speed");
        this.angle = compound.m_128457_("Angle");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Speed", this.speed);
        compound.m_128350_("Angle", this.angle);
    }

    public double m_6048_() {
        return 2.3;
    }

    @Override
    public boolean hideRider() {
        return true;
    }

    @Override
    public boolean zoomOutCameraInThirdPerson() {
        return true;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        return super.m_7688_(passenger).m_82549_(passenger.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82492_(0.0, 2.0, 0.0));
    }

    @Override
    public boolean isSafeToDismount(Player player) {
        return this.m_20096_();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        passenger.m_146922_(this.m_146908_());
        passenger.m_5616_(this.m_6080_());
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        passenger.m_146922_(passenger.m_146908_() + this.angle);
        passenger.m_5616_(passenger.m_6080_() + this.angle);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            this.flightTick();
        } else {
            this.angle = 0.0f;
        }
    }

    private void flightTick() {
        Vec3 delta = this.m_20184_();
        float xxa = -this.xxa();
        this.angle = xxa != 0.0f ? (this.angle += xxa * 1.0f) : (this.angle *= 0.9f);
        if (this.passengerHasSpaceDown() && delta.f_82480_ < -0.05) {
            this.speed += 0.01f;
            this.f_19789_ *= 0.9f;
            this.spawnLanderParticles();
            if (this.m_9236_().m_5776_() && !this.startedRocketSound) {
                this.startedRocketSound = true;
                SoundUtils.playLanderSound(this);
            }
        } else if ((double)this.speed > -1.1) {
            this.speed -= 0.01f;
        }
        this.angle = Mth.m_14036_((float)this.angle, (float)-3.0f, (float)3.0f);
        this.m_146922_(this.m_146908_() + this.angle);
        this.m_20334_(delta.m_7096_(), this.speed, delta.m_7094_());
        if (this.m_20069_()) {
            this.m_20334_(delta.m_7096_(), Math.min(0.06, delta.m_7098_() + 0.15), delta.m_7094_());
            this.speed *= 0.9f;
        }
    }

    public void explode() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, OxygenApi.API.hasOxygen(this.m_9236_()), Level.ExplosionInteraction.TNT);
        this.m_146870_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (fallDistance > 40.0f && this.m_20096_()) {
            this.explode();
            return true;
        }
        return false;
    }

    public void spawnLanderParticles() {
        int i;
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        for (i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.LARGE_FLAME.get(), this.m_20185_(), this.m_20186_() - 0.2, this.m_20189_(), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05));
        }
        for (i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.LARGE_SMOKE.get(), this.m_20185_(), this.m_20186_() - 0.2, this.m_20189_(), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05), Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.05, (double)0.05));
        }
    }

    @Override
    public ItemStack getDropStack() {
        return ItemStack.f_41583_;
    }

    @Override
    public int getInventorySize() {
        return 11;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new LanderMenu(containerId, inventory, this);
    }
}

