/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.events.common;

import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.exceptions.ATLUnsupportedOperation;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.mixin.Trackable;
import dev.uncandango.alltheleaks.report.ReportManager;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.throwables.ClassAlreadyLoadedException;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.perf.Profiler;

@Mod.EventBusSubscriber(modid="alltheleaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvent {
    private static final ClickEvent LINK_TO_REPORT = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/pietro-lopes/AllTheLeaks/issues/5");
    private static final HoverEvent HOVER_LINK = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click here").m_130940_(ChatFormatting.GREEN));
    private static final Component REPORT_TO_DEV = Component.m_237113_((String)"[report to developer]").m_130938_(style -> style.m_131142_(LINK_TO_REPORT).m_131144_(HOVER_LINK).m_131140_(ChatFormatting.GREEN));
    public static int reports = 0;

    @SubscribeEvent
    public static void onModLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            if (ATLProperties.get().ingredientDedupe) {
                ReportManager.registerTask("ingame_ingredient_dedupe_errors", 300, ModEvent::reportIngameIngredientDedupeErrors);
            }
            ReportManager.registerTask("clear_memory_leak_map", 6000, Trackable::clearNullReferences);
            CrashReportCallables.registerCrashCallable((String)"AllTheLeaks", ModEvent::generateReportForCrashReport);
            ReportManager.registerTask("passive_memory_leak_report", 12000, () -> MemoryMonitor.logFullSummary(arg_0 -> ((Logger)AllTheLeaks.LOGGER).info(arg_0)));
            ReportManager.registerTask("update_leak_summary", 100, MemoryMonitor::updateLeakSummary);
            ReportManager.registerTask("too_much_memory_usage", 100, MemoryMonitor::tooMuchMemoryUsage);
            if (AllTheLeaks.INDEV) {
                ModEvent.auditMyMixinsOnly();
            }
        });
    }

    private static void auditMyMixinsOnly() {
        try {
            Class<?> MIXIN_CONFIG_CLASS = ReflectionHelper.getClass("org.spongepowered.asm.mixin.transformer.MixinConfig");
            MethodHandle unhandledMixinsMH = ReflectionHelper.getMethodFromClass(MIXIN_CONFIG_CLASS, "getUnhandledTargets", MethodType.methodType(Set.class), false);
            Config config = Config.create((String)"alltheleaks.mixins.json");
            Set unhandled = unhandledMixinsMH.invoke(config.getConfig());
            ILogger auditLogger = MixinService.getService().getLogger("mixin.audit");
            for (String target : unhandled) {
                try {
                    auditLogger.info("Force-loading class {}", new Object[]{target});
                    MixinService.getService().getClassProvider().findClass(target, true);
                }
                catch (ClassNotFoundException ex) {
                    auditLogger.error("Could not force-load " + target, (Throwable)ex);
                }
            }
            for (String target : unhandledMixinsMH.invoke(config.getConfig())) {
                ClassAlreadyLoadedException ex = new ClassAlreadyLoadedException(target + " was already classloaded");
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
            if (MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_PROFILER)) {
                Profiler.printAuditSummary();
            }
        }
        catch (Throwable e) {
            AllTheLeaks.LOGGER.error("Error while auditing mixins", e);
        }
    }

    private static void reportIngameIngredientDedupeErrors() {
        if (FMLEnvironment.dist.isClient()) {
            int count;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (count = ATLUnsupportedOperation.getUnreportedErrorCount()) > 0) {
                MutableComponent message = Component.m_237110_((String)"[AllTheLeaks] There are %s errors related to Ingredient Dedupe, check logs for more info and %s.", (Object[])new Object[]{count, REPORT_TO_DEV}).m_130940_(ChatFormatting.RED);
                player.m_213846_((Component)message);
            }
        } else {
            int count;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (count = ATLUnsupportedOperation.getUnreportedErrorCount()) > 0) {
                AllTheLeaks.LOGGER.warn("[AllTheLeaks] There are {} errors related to Ingredient Dedupe, check logs for more info and report to {}.", (Object)count, (Object)"https://github.com/pietro-lopes/AllTheLeaks/issues/5");
            }
        }
    }

    private static String generateReportForCrashReport() {
        if (++reports % 2 == 1) {
            MemoryMonitor.runExplicitGc();
        }
        Trackable.clearNullReferences();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (ATLProperties.get().ingredientDedupe) {
            sb.append("\t\tIngredient Dedupe Errors: ").append(ATLUnsupportedOperation.getErrorCount()).append("\n");
        }
        sb.append("\t\tEvents:\n");
        MemoryMonitor.getEventsSummary().forEach(line -> sb.append("\t\t  ").append((String)line).append("\n"));
        sb.append("\t\tExplicit GC Last Run: ").append((String)(MemoryMonitor.isExplicitGcDisabled() ? "Disabled" : Util.m_137550_() - MemoryMonitor.lastRunGc() + "ms ago")).append("\n");
        if (MemoryMonitor.isExplicitGcDisabled()) {
            sb.append("\t\tNote: Values below are not accurate due to -XX:+DisableExplicitGC arguments you are using").append("\n");
        }
        sb.append("\t\tLeaking objects:\n");
        Trackable.getSummary().forEach((baseClazz, mapCount) -> {
            if (!mapCount.isEmpty()) {
                sb.append("\t\t  ").append(baseClazz.getSimpleName()).append(":\n");
            }
            mapCount.forEach((innerClazz, count) -> sb.append("\t\t    ").append(innerClazz.getSimpleName()).append(": ").append(count).append("\n"));
        });
        return sb.toString();
    }
}

