/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.AppliedAmmoBox.item;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.me.helpers.PlayerSource;
import com.nanaios.AppliedAmmoBox.item.ICheckedTimeStampable;
import com.nanaios.AppliedAmmoBox.item.WirelessAmmoBoxBase;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WirelessAmmoBoxItem
extends WirelessAmmoBoxBase
implements ICheckedTimeStampable {
    public WirelessAmmoBoxItem() {
        super(AEConfig.instance().getWirelessTerminalBattery());
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        this.player = (Player)entity;
        ItemStack mainHandStack = this.player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = mainHandStack.m_41720_();
        if (item instanceof IGun) {
            IGun gun = (IGun)item;
            ResourceLocation gunId = gun.getGunId(mainHandStack);
            ResourceLocation ammoId = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(commonGunIndex -> commonGunIndex.getGunData().getAmmoId()).orElse(DefaultAssets.EMPTY_AMMO_ID);
            if (ammoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                return;
            }
            if (!ammoId.toString().equals(this.getAmmoId(stack).toString())) {
                this.setAmmoId(stack, ammoId);
                this.setMarkUpdate(stack, true);
            }
            if (System.currentTimeMillis() - this.getLastCheckedTimeStamp(stack) > 1000L || this.getMarkUpdate(stack)) {
                this.setLastCheckedTimeStamp(stack, System.currentTimeMillis());
                this.setMarkUpdate(stack, false);
                int storageAmmoCount = this.getAmmoCountInMEStorage(stack, ammoId, this.player);
                super.setAmmoCount(stack, storageAmmoCount);
            }
        }
    }

    public boolean isAmmoBoxOfGun(ItemStack gun, ItemStack ammoBox) {
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            item = ammoBox.m_41720_();
            if (item instanceof IAmmoBox) {
                IAmmoBox iAmmoBox = (IAmmoBox)item;
                ResourceLocation ammoId = iAmmoBox.getAmmoId(ammoBox);
                ResourceLocation gunId = iGun.getGunId(gun);
                boolean isEqualAmmoId = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
                boolean isHaveAmmo = iAmmoBox.getAmmoCount(ammoBox) > 0;
                return isEqualAmmoId && isHaveAmmo;
            }
        }
        return false;
    }

    private int getAmmoCountInMEStorage(ItemStack ammoBox, ResourceLocation ammoId, Player player) {
        IGrid grid = this.getGrid(ammoBox);
        if (grid == null) {
            return 0;
        }
        if (!this.rangeCheck()) {
            return 0;
        }
        IGridNode node = this.getActionableNode();
        if (node == null) {
            return 0;
        }
        PlayerSource source = new PlayerSource(player);
        ItemStack ammoStack = AmmoItemBuilder.create().setId(ammoId).setCount(1).build();
        AEItemKey key = AEItemKey.of((ItemStack)ammoStack);
        if (key == null) {
            return 0;
        }
        return (int)StorageHelper.poweredExtraction((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)key, (long)Integer.MAX_VALUE, (IActionSource)source, (Actionable)Actionable.SIMULATE);
    }

    public void setAmmoCount(ItemStack ammoBox, int count) {
        int nowAmmoCount = this.getAmmoCount(ammoBox);
        ResourceLocation ammoId = this.getAmmoId(ammoBox);
        int needAmmoCount = nowAmmoCount - count;
        IGrid grid = this.getGrid(ammoBox);
        if (grid == null) {
            return;
        }
        IGridNode node = this.getActionableNode();
        if (node == null) {
            return;
        }
        PlayerSource source = new PlayerSource(this.player);
        ItemStack ammoStack = AmmoItemBuilder.create().setId(ammoId).setCount(1).build();
        AEItemKey key = AEItemKey.of((ItemStack)ammoStack);
        if (key == null) {
            return;
        }
        double needPower = (double)needAmmoCount * 1000.0;
        double extractPower = this.extractAEPower(ammoBox, needPower, Actionable.SIMULATE);
        this.extractAEPower(ammoBox, extractPower, Actionable.MODULATE);
        int extractableAmmoCount = (int)StorageHelper.poweredExtraction((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)key, (long)needAmmoCount, (IActionSource)source, (Actionable)Actionable.SIMULATE);
        StorageHelper.poweredExtraction((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)key, (long)extractableAmmoCount, (IActionSource)source, (Actionable)Actionable.MODULATE);
        this.setMarkUpdate(ammoStack, true);
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, components, isAdvanced);
        if (this.getLinkedPosition(stack) == null) {
            components.add((Component)Tooltips.of((GuiText)GuiText.Unlinked, (Style)Tooltips.RED, (Object[])new Object[0]));
        } else {
            components.add((Component)Tooltips.of((GuiText)GuiText.Linked, (Style)Tooltips.GREEN, (Object[])new Object[0]));
        }
    }
}

