/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.AppliedAmmoBox.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nanaios.AppliedAmmoBox.AppliedAmmoBox;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class NbtIngredient
extends Ingredient {
    private final Item item;
    private final CompoundTag requiredTag;

    public NbtIngredient(Item item, CompoundTag tag) {
        super(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)item))));
        this.item = item;
        this.requiredTag = tag;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        if (!stack.m_150930_(this.item)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        for (String key : this.requiredTag.m_128431_()) {
            if (tag.m_128441_(key) && Objects.equals(tag.m_128423_(key), this.requiredTag.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static void register() {
        CraftingHelper.register((ResourceLocation)AppliedAmmoBox.rl("nbt"), (IIngredientSerializer)Serializer.INSTANCE);
    }

    public static class Serializer
    implements IIngredientSerializer<NbtIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public NbtIngredient parse(JsonObject json) {
            ResourceLocation itemId = AppliedAmmoBox.rlSingle(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            CompoundTag tag = null;
            if (json.has("nbt")) {
                try {
                    tag = TagParser.m_129359_((String)GsonHelper.m_13930_((JsonObject)json, (String)"nbt").toString());
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException("Invalid NBT in ingredient: " + String.valueOf(json), (Throwable)e);
                }
            }
            return new NbtIngredient(item, tag);
        }

        public NbtIngredient parse(FriendlyByteBuf buffer) {
            Item item = (Item)buffer.readRegistryIdSafe(Item.class);
            CompoundTag tag = buffer.m_130260_();
            return new NbtIngredient(item, tag);
        }

        public void write(FriendlyByteBuf buffer, NbtIngredient ingredient) {
            buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)ingredient.item);
            buffer.m_130079_(ingredient.requiredTag);
        }
    }
}

