/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.AppliedAmmoBox.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nanaios.AppliedAmmoBox.recipes.AppliedAmmoBoxRecipes;
import com.nanaios.AppliedAmmoBox.recipes.NbtIngredient;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class ShapedNbtRecipe
extends ShapedRecipe {
    public ShapedNbtRecipe(ShapedRecipe base) {
        super(base.m_6423_(), base.m_6076_(), base.m_245232_(), base.m_44220_(), base.m_44221_(), base.m_7527_(), base.m_8043_(null));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AppliedAmmoBoxRecipes.SHAPED_NBT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedNbtRecipe> {
        public ShapedNbtRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapedRecipe base = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(id, json);
            JsonObject keys = GsonHelper.m_13930_((JsonObject)json, (String)"key");
            JsonArray patterns = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < base.m_44221_(); ++i) {
                String pattern = patterns.get(i).getAsString();
                for (int j = 0; j < pattern.length(); ++j) {
                    Ingredient ingredient = (Ingredient)base.m_7527_().get(3 * i + j);
                    char code = pattern.charAt(j);
                    for (Map.Entry entry : keys.entrySet()) {
                        char key = ((String)entry.getKey()).charAt(0);
                        if (key != code) continue;
                        JsonObject obj = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                        if (!obj.has("nbt")) break;
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"item")));
                        try {
                            CompoundTag tag = TagParser.m_129359_((String)obj.get("nbt").toString());
                            ingredient = new NbtIngredient(item, tag);
                        }
                        catch (CommandSyntaxException e) {
                            throw new JsonParseException("Invalid NBT in recipe: " + e.getMessage());
                        }
                    }
                    ingredients.add((Object)ingredient);
                }
            }
            return new ShapedNbtRecipe(new ShapedRecipe(base.m_6423_(), base.m_6076_(), base.m_245232_(), base.m_44220_(), base.m_44221_(), ingredients, base.m_8043_(null)));
        }

        public ShapedNbtRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapedRecipe base = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(id, buf);
            return new ShapedNbtRecipe(base);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedNbtRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buf, (Recipe)recipe);
        }
    }
}

