/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StoredItemStack {
    private ItemStack stack;
    private long count;
    private static final String ITEM_COUNT_NAME = "c";
    private static final String ITEMSTACK_NAME = "s";
    private int hash;

    public StoredItemStack(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(ItemStack stack) {
        this.stack = stack.m_41777_();
        this.stack.m_41764_(1);
        this.count = stack.m_41613_();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public ItemStack getActualStack() {
        ItemStack s = this.stack.m_41777_();
        s.m_41764_((int)this.count);
        return s;
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128356_(ITEM_COUNT_NAME, this.getQuantity());
        tag.m_128365_(ITEMSTACK_NAME, (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128469_(ITEMSTACK_NAME).m_128473_("Count");
        return tag;
    }

    public CompoundTag writeToNBT(CompoundTag tag, long q) {
        tag.m_128356_(ITEM_COUNT_NAME, q);
        tag.m_128365_(ITEMSTACK_NAME, (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128469_(ITEMSTACK_NAME).m_128473_("Count");
        return tag;
    }

    public static StoredItemStack readFromNBT(CompoundTag tag) {
        ItemStack cheat = ItemStack.m_41712_((CompoundTag)tag);
        tag.m_128469_(ITEMSTACK_NAME).m_128344_("Count", (byte)1);
        StoredItemStack stack = new StoredItemStack(!cheat.m_41619_() ? cheat : ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEMSTACK_NAME)), !cheat.m_41619_() ? (long)cheat.m_41613_() : tag.m_128454_(ITEM_COUNT_NAME));
        return !stack.stack.m_41619_() ? stack : null;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.m_41720_().hashCode());
            this.hash = result = 31 * result + (this.stack == null || !this.stack.m_41782_() ? 0 : this.stack.m_41783_().hashCode());
            return result;
        }
        return this.hash;
    }

    public String getDisplayName() {
        return this.stack.m_41786_().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        if (this.stack == null) {
            return other.stack == null;
        }
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)other.stack) && ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.stack == null) {
            return other.stack == null;
        }
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)other.stack) && ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public void grow(long c) {
        this.count += c;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getMaxStackSize() {
        return this.stack.m_41741_();
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().m_41786_().getString().compareTo(in2.getStack().m_41786_().getString()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

