/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.lang.reflect.Field;
import java.util.Arrays;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.Configurable;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ArrayValue;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class BooleanArrayValue
extends ConfigValue<boolean[]>
implements ArrayValue {
    private boolean fixedSize;

    public BooleanArrayValue(ValueData<boolean[]> valueData) {
        super(valueData);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void readFieldData(Field field) {
        this.fixedSize = field.getAnnotation(Configurable.FixedSize.class) != null;
    }

    @Override
    protected boolean[] getCorrectedValue(boolean[] in) {
        boolean[] defaultArray;
        if (this.fixedSize && in.length != (defaultArray = (boolean[])this.valueData.getDefaultValue()).length) {
            ConfigUtils.logArraySizeCorrectedMessage(this.getId(), Arrays.toString(in), Arrays.toString(defaultArray));
            return defaultArray;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeBoolArray(this.getId(), (boolean[])this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readBoolArray(this.getId()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean[] booleans = (boolean[])this.get();
        for (int i = 0; i < booleans.length; ++i) {
            builder.append(this.elementToString(booleans[i]));
            if (i >= booleans.length - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new BooleanArrayValue(ValueData.of(name, (boolean[])value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            boolean[] arr = (boolean[])value.get();
            buffer.writeInt(arr.length);
            for (boolean b : arr) {
                buffer.writeBoolean(b);
            }
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            boolean[] arr = new boolean[buffer.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = buffer.readBoolean();
            }
            return arr;
        }
    }
}

