/*
 * Decompiled with CFR 0.152.
 */
package de.presti.ccbx.ccbx;

import ballistix.common.block.BlockExplosive;
import ballistix.common.item.ItemMissile;
import ballistix.common.tile.TileMissileSilo;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.presti.ccbx.ccbx.BallistixUtil;
import de.presti.ccbx.ccbx.CCBallistiXTileEntity;
import electrodynamics.common.blockitem.types.BlockItemDescriptable;
import electrodynamics.prefab.tile.components.IComponentType;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CCBallistiXPeripheral
implements IPeripheral {
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    private final CCBallistiXTileEntity tileEntity;

    public CCBallistiXPeripheral(CCBallistiXTileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Nonnull
    public String getType() {
        return "siloController";
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public CCBallistiXTileEntity getTileEntity() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final boolean launch() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return false;
        }
        tileMissileSilo.shouldLaunch = true;
        BlockPos targetPosition = (BlockPos)tileMissileSilo.target.get();
        for (IComputerAccess computerAccess : this.connectedComputers) {
            computerAccess.queueEvent("ccbx_launch", new Object[]{targetPosition.m_123341_(), targetPosition.m_123342_(), targetPosition.m_123343_()});
        }
        return true;
    }

    @LuaFunction(mainThread=true)
    public final boolean launchWithPosition(int x, int y, int z) {
        this.setPosition(x, y, z);
        return this.launch();
    }

    @LuaFunction(mainThread=true)
    public boolean getLaunchState() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return false;
        }
        return tileMissileSilo.shouldLaunch;
    }

    @LuaFunction(mainThread=true)
    public int getRange() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return 0;
        }
        if (tileMissileSilo.range == null) {
            return 0;
        }
        return (Integer)tileMissileSilo.range.get();
    }

    @LuaFunction(mainThread=true)
    public final String getExplosiveType() {
        BlockItemDescriptable des;
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return "";
        }
        ComponentInventory inv = (ComponentInventory)tileMissileSilo.getComponent(IComponentType.Inventory);
        ItemStack explosive = inv.m_8020_(1);
        if (explosive == null) {
            return "";
        }
        Item item = explosive.m_41720_();
        if (item instanceof BlockItemDescriptable && (item = (des = (BlockItemDescriptable)item).m_40614_()) instanceof BlockExplosive) {
            BlockExplosive blockExplosive = (BlockExplosive)item;
            return blockExplosive.explosive.tag();
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final int getExplosiveAmount() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return 0;
        }
        ComponentInventory inv = (ComponentInventory)tileMissileSilo.getComponent(IComponentType.Inventory);
        ItemStack explosive = inv.m_8020_(1);
        if (explosive == null) {
            return 0;
        }
        return explosive.m_41613_();
    }

    @LuaFunction(mainThread=true)
    public final String getMissileType() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return null;
        }
        ComponentInventory inv = (ComponentInventory)tileMissileSilo.getComponent(IComponentType.Inventory);
        ItemStack missileItem = inv.m_8020_(0);
        Item item = missileItem.m_41720_();
        if (item instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)item;
            return missile.missile.tag();
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final int getMissileAmount() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return 0;
        }
        ComponentInventory inv = (ComponentInventory)tileMissileSilo.getComponent(IComponentType.Inventory);
        ItemStack missile = inv.m_8020_(0);
        if (missile == null) {
            return 0;
        }
        return missile.m_41613_();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getPosition() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return info;
        }
        if (tileMissileSilo.target == null) {
            return info;
        }
        BlockPos position = (BlockPos)tileMissileSilo.target.get();
        info.put("x", position.m_123341_());
        info.put("y", position.m_123342_());
        info.put("z", position.m_123343_());
        return info;
    }

    @LuaFunction(mainThread=true)
    public final void setPosition(int x, int y, int z) {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return;
        }
        tileMissileSilo.target.set((Object)new BlockPos(x, y, z));
        for (IComputerAccess computerAccess : this.connectedComputers) {
            computerAccess.queueEvent("ccbx_update_position", new Object[]{x, y, z});
        }
    }

    @LuaFunction(mainThread=true)
    public final int getFrequency() {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return 0;
        }
        if (tileMissileSilo.frequency == null) {
            return 0;
        }
        return (Integer)tileMissileSilo.frequency.get();
    }

    @LuaFunction(mainThread=true)
    public final void setFrequency(int freq) {
        TileMissileSilo tileMissileSilo = this.getMissileSilo();
        if (tileMissileSilo == null) {
            return;
        }
        for (IComputerAccess computerAccess : this.connectedComputers) {
            computerAccess.queueEvent("ccbx_update_frequency", new Object[]{freq});
        }
        tileMissileSilo.frequency.set((Object)freq);
    }

    public TileMissileSilo getMissileSilo() {
        return BallistixUtil.getMissileSilo(this.getTileEntity().m_58904_(), this.getTileEntity().m_58899_().m_7494_());
    }
}

