/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCItems;

public class BlockArmorInspectionToolItem
extends Item {
    private static final List<Predicate<Player>> IS_HOLDING_PREDICATES = new ArrayList<Predicate<Player>>();

    public BlockArmorInspectionToolItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public static boolean isHoldingTool(Player player) {
        for (Predicate<Player> predicate : IS_HOLDING_PREDICATES) {
            if (!predicate.test(player)) continue;
            return true;
        }
        return false;
    }

    public static void addBlockArmorInfo(List<Component> tooltip, Level level, BlockPos pos, BlockState blockState) {
        if (blockState.m_60795_()) {
            return;
        }
        String precision = ((Integer)CBCConfigs.client().blockArmorTooltipPrecision.get()).toString();
        String format = "%." + precision + "f";
        BlockArmorPropertiesProvider provider = BlockArmorPropertiesHandler.getProperties(blockState);
        double toughness = provider.toughness(level, blockState, pos, true);
        double hardness = provider.hardness(level, blockState, pos, true);
        CreateLang.builder().add(Component.m_237115_((String)"debug.createbigcannons.block_armor_info")).forGoggles(tooltip);
        CreateLang.builder().add(Component.m_237115_((String)"debug.createbigcannons.block_toughness").m_130940_(ChatFormatting.GRAY)).add(Component.m_237113_((String)String.format(format, toughness)).m_130940_(ChatFormatting.GOLD)).forGoggles(tooltip, 1);
        CreateLang.builder().add(Component.m_237115_((String)"debug.createbigcannons.block_hardness").m_130940_(ChatFormatting.GRAY)).add(Component.m_237113_((String)String.format(format, hardness)).m_130940_(ChatFormatting.GOLD)).forGoggles(tooltip, 1);
    }

    public static void addIsHoldingPredicate(Predicate<Player> predicate) {
        IS_HOLDING_PREDICATES.add(predicate);
    }

    public static void registerDefaultHandlers() {
        BlockArmorInspectionToolItem.addIsHoldingPredicate(BlockArmorInspectionToolItem::defaultHandler);
    }

    private static boolean defaultHandler(Player player) {
        return CBCItems.BLOCK_ARMOR_INSPECTION_TOOL.isIn(player.m_21205_()) || CBCItems.BLOCK_ARMOR_INSPECTION_TOOL.isIn(player.m_21206_());
    }
}

