/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.CRNListBox;
import de.mrjulsen.crn.client.gui.widgets.DLCreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TrustedPlayersWidget
extends DLWidgetContainer {
    private final Screen parent;
    private final CRNListBox<Owner, Entry> listbox;
    private final Map<String, Owner> playerListByName = new HashMap<String, Owner>();
    private final Set<Owner> currentPlayerList = new HashSet<Owner>();
    private String searchText = "";

    public TrustedPlayersWidget(Screen parent, int x, int y, int width, int height, GlobalSettingsScreen.IPlayerListSuggestionData suggestions, Set<Owner> currentPlayerList) {
        super(x, y, width, height);
        this.parent = parent;
        this.currentPlayerList.addAll(currentPlayerList);
        GuiAreaDefinition listArea = new GuiAreaDefinition(this.x(), this.y() + 16, this.width() - 5, this.height() - 16 - 18);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar(this.parent, listArea.getRight(), listArea.getY(), listArea.getHeight(), listArea);
        this.listbox = (CRNListBox)this.addRenderableWidget((GuiEventListener)new CRNListBox(this.parent, listArea.getX(), listArea.getY(), listArea.getWidth(), listArea.getHeight(), (DLAbstractScrollBar<?>)scrollBar));
        this.addRenderableWidget((GuiEventListener)scrollBar);
        DLEditBox addBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLCreateTextBox(this.font, this.x(), this.y() + this.height() - 18, this.width() - 18, (Component)TextUtils.empty()));
        addBox.m_94151_(value -> suggestions.run(addBox, this.playerListByName.values(), this.currentPlayerList));
        DLIconButton addBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.ADD.getAsSprite(16, 16), this.x() + this.width() - 18, this.y() + this.height() - 18, (Component)TextUtils.empty(), btn -> {
            if (addBox.m_94155_() != null && !addBox.m_94155_().isBlank() && this.playerListByName.containsKey(addBox.m_94155_())) {
                this.currentPlayerList.add(this.playerListByName.get(addBox.m_94155_()));
                addBox.m_94144_("");
                this.reload();
            }
        }));
        addBtn.setBackColor(0);
        DLEditBox searchBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, this.x() + 1, this.y() + 1, this.width() - 2, 14, (Component)TextUtils.empty()){

            public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
                if (code == 257) {
                    TrustedPlayersWidget.this.searchText = this.m_94155_();
                    TrustedPlayersWidget.this.refreshListBox();
                    return true;
                }
                return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
            }
        });
        searchBox.m_94144_(this.searchText);
        searchBox.withHint(DragonLib.TEXT_SEARCH);
        this.reload();
    }

    private void reload() {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ONLINE_PLAYERS, list -> {
            this.playerListByName.clear();
            for (Owner o : list) {
                this.playerListByName.put(o.name(), o);
            }
            this.refreshListBox();
        });
    }

    private void refreshListBox() {
        this.listbox.displayData(this.currentPlayerList.stream().filter(x -> x.name().toLowerCase(Locale.ROOT).contains(this.searchText.toLowerCase(Locale.ROOT))).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).toList(), (player, i) -> new Entry(this, this.x(), this.y(), this.listbox.width(), (Owner)player));
    }

    public Set<Owner> getPlayers() {
        return this.currentPlayerList;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static class Entry
    extends DLWidgetContainer {
        private final Owner player;

        public Entry(TrustedPlayersWidget parent, int x, int y, int width, Owner player) {
            super(x, y, width, 18);
            this.player = player;
            DLIconButton deleteBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.DELETE.getAsSprite(16, 16), this.x() + this.width() - 16, this.y() + 1, 16, 16, (Component)TextUtils.empty(), btn -> {
                parent.currentPlayerList.removeIf(a -> a.equals(player));
                parent.refreshListBox();
            }));
            deleteBtn.setBackColor(0);
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
            CreateDynamicWidgets.renderTextSlotOverlay(graphics, this.x(), this.y() + 1, this.width() - 18, this.height() - 2);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 5), (int)(this.y() + 5), (String)this.player.name(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.HOVERED;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        public boolean consumeScrolling(double mouseX, double mouseY) {
            return false;
        }
    }
}

