/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoEntityRenderer;
import mod.azure.azurelib.util.RenderUtils;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.models.projectiles.BFGBallModel;
import mod.azure.doom.entities.projectiles.BFGEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BFGCellRender
extends GeoEntityRenderer<BFGEntity> {
    private static final RenderType CRYSTAL_BEAM_LAYER = RenderType.m_110473_((ResourceLocation)MCDoom.modResource("textures/entity/projectiles/bfg_beam.png"));

    public BFGCellRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new BFGBallModel());
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, float x, float y, float z, float u, float v) {
        vertexConsumer.m_252986_(positionMatrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    protected int getBlockLightLevel(@NotNull BFGEntity entityIn, @NotNull BlockPos partialTicks) {
        return 15;
    }

    public boolean shouldRender(@NotNull BFGEntity entity, @NotNull Frustum frustum, double x, double y, double z) {
        LivingEntity livingEntity;
        if (super.m_5523_((Entity)entity, frustum, x, y, z)) {
            return true;
        }
        if (entity.hasTargetedEntity() && (livingEntity = entity.getTargetedEntity()) != null) {
            Vec3 vec3 = this.fromLerpedPosition((Entity)livingEntity, (double)livingEntity.m_20206_() * 0.5, 1.0f);
            Vec3 vec31 = this.fromLerpedPosition((Entity)entity, entity.m_20192_(), 1.0f);
            return frustum.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    private Vec3 fromLerpedPosition(Entity entity, double yOffset, float delta) {
        return new Vec3(Mth.m_14139_((double)delta, (double)entity.f_19790_, (double)entity.m_20185_()), Mth.m_14139_((double)delta, (double)entity.f_19791_, (double)entity.m_20186_()) + yOffset, Mth.m_14139_((double)delta, (double)entity.f_19792_, (double)entity.m_20189_()));
    }

    public void render(@NotNull BFGEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        LivingEntity livingEntity = entity.getTargetedEntity();
        if (livingEntity != null) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, entity.m_20192_(), 0.0f);
            Vec3 vec3 = this.fromLerpedPosition((Entity)livingEntity, (double)livingEntity.m_20206_() * 0.5, partialTick).m_82546_(this.fromLerpedPosition((Entity)entity, entity.m_20192_(), partialTick));
            vec3 = vec3.m_82541_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(1.5707963705062866 - Math.atan2(vec3.f_82481_, vec3.f_82479_)) * 57.295776f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Math.acos(vec3.f_82480_) * 57.295776f));
            float aa = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 0.7853982f)) * 0.282f;
            float ab = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 3.926991f)) * 0.282f;
            float ac = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 3.926991f)) * 0.282f;
            float ad = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 5.4977875f)) * 0.282f;
            float ae = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 5.4977875f)) * 0.282f;
            float af = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + (float)Math.PI)) * 0.2f;
            float ag = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + (float)Math.PI)) * 0.2f;
            float ah = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 0.0f)) * 0.2f;
            float ai = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 0.0f)) * 0.2f;
            float aj = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 1.5707964f)) * 0.2f;
            float ak = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 1.5707964f)) * 0.2f;
            float al = Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 4.712389f)) * 0.2f;
            float am = Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 4.712389f)) * 0.2f;
            double an = vec3.m_82553_() + 1.0;
            float aq = -1.0f + (float)entity.m_9236_().m_46467_() + partialTick * 0.5f % 1.0f;
            double ar = (vec3.m_82553_() + 1.0) * 2.5 + (double)aq;
            VertexConsumer vertexConsumer = bufferSource.m_6299_(CRYSTAL_BEAM_LAYER);
            PoseStack.Pose entry = poseStack.m_85850_();
            Matrix4f matrix4f = entry.m_252922_();
            Matrix3f matrix3f = entry.m_252943_();
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, af, (float)an, ag, 0.4999f, (float)ar);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, af, 0.0f, ag, 0.4999f, aq);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, ah, 0.0f, ai, 0.0f, aq);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, ah, (float)an, ai, 0.0f, (float)ar);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, aj, (float)an, ak, 0.4999f, (float)ar);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, aj, 0.0f, ak, 0.4999f, aq);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, al, 0.0f, am, 0.0f, aq);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, al, (float)an, am, 0.0f, (float)ar);
            float as = 0.0f;
            if (entity.f_19797_ % 2 == 0) {
                as = 0.5f;
            }
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 2.3561945f)) * 0.282f, (float)an, Mth.m_14031_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 2.3561945f)) * 0.282f, 0.5f, as + 0.5f);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, Mth.m_14089_((float)((float)entity.m_9236_().m_46467_() + partialTick * 0.05f * -1.5f + 0.7853982f)) * 0.282f, (float)an, aa, 1.0f, as + 0.5f);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, ad, (float)an, ae, 1.0f, as);
            BFGCellRender.vertex(vertexConsumer, matrix4f, matrix3f, ab, (float)an, ac, 0.5f, as);
            poseStack.m_85849_();
        }
    }

    public void preRender(PoseStack poseStack, BFGEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtils.faceRotation((PoseStack)poseStack, (Entity)animatable, (float)partialTick);
        poseStack.m_85841_(animatable.f_19797_ > 2 ? 0.5f : 0.0f, animatable.f_19797_ > 2 ? 0.5f : 0.0f, animatable.f_19797_ > 2 ? 0.5f : 0.0f);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

