/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles;

import java.util.Objects;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.tierboss.DoomBoss;
import mod.azure.doom.helper.PlayerProperties;
import mod.azure.doom.items.enums.GunTypeEnum;
import mod.azure.doom.items.weapons.DoomBaseItem;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MeatHookEntity
extends AbstractArrow
implements GeoEntity {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.m_135353_(MeatHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> HOOKED_ENTITY_ID = SynchedEntityData.m_135353_(MeatHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private double maxRange = 0.0;
    private double maxSpeed = 0.0;
    private boolean isPulling = false;
    private Entity hookedEntity;
    private ItemStack stack;
    private int attachTimer = 0;
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(MeatHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private long lastUpdateTime = 0L;

    public MeatHookEntity(EntityType<? extends AbstractArrow> type, Player owner, Level world) {
        super(type, (LivingEntity)owner, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world, LivingEntity owner) {
        super(Services.ENTITIES_HELPER.getMeatHookEntity(), owner, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world, double x, double y, double z) {
        super(Services.ENTITIES_HELPER.getMeatHookEntity(), x, y, z, world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(Level world) {
        super(Services.ENTITIES_HELPER.getMeatHookEntity(), world);
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public MeatHookEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOOKED_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(FORCED_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public Integer getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(Integer variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.m_20242_(true);
        if (this.f_19797_ >= 40 && !this.m_20159_()) {
            this.m_6074_();
        }
        if (!this.m_9236_().m_5776_()) {
            ++this.attachTimer;
        }
        if (this.getVariant() == 0) {
            this.doMeatHook();
        }
        if (this.getVariant() == 1 && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            this.doMicrowaveBeam(owner);
            if (this.m_9236_().f_46443_ && this.m_19749_() instanceof Player) {
                this.renderParticles();
            }
        }
    }

    private void renderParticles() {
        double bodyYawToRads = Math.toRadians(Objects.requireNonNull((LivingEntity)this.m_19749_()).f_20883_);
        double radius = MCDoom.config.enable_noncenter ? -0.15 : 5.0;
        double playerX = this.m_19749_().m_20185_() + radius * Math.cos(bodyYawToRads);
        double playerY = this.m_19749_().m_20227_(0.8);
        double playerZ = this.m_19749_().m_20189_() + radius * Math.sin(bodyYawToRads);
        Vec3 lookVector = this.m_19749_().m_20154_();
        double arrowX = playerX + lookVector.f_82479_ * 10.0;
        double arrowY = playerY + lookVector.f_82480_ * 10.0;
        double arrowZ = playerZ + lookVector.f_82481_ * 10.0;
        double directionX = arrowX - playerX;
        double directionY = arrowY - playerY;
        double directionZ = arrowZ - playerZ;
        double stepX = directionX / 15.0;
        double stepY = directionY / 15.0;
        double stepZ = directionZ / 15.0;
        for (int i = 0; i < 20; ++i) {
            double offsetX = this.m_9236_().f_46441_.m_188500_() * 0.2 - 0.1;
            double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.2 - 0.1;
            double offsetZ = this.m_9236_().f_46441_.m_188500_() * 0.2 - 0.1;
            double particleX = playerX + stepX * (double)i + offsetX;
            double particleY = playerY + stepY * (double)i + offsetY;
            double particleZ = playerZ + stepZ * (double)i + offsetZ;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }

    private void doMeatHook() {
        Entity entity;
        if (this.f_19797_ % 16 == 2) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        if ((entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            this.m_146922_(((Float)this.f_19804_.m_135370_(FORCED_YAW)).floatValue());
            if (this.isPulling && this.f_19797_ % 2 == 0) {
                this.m_9236_().m_5594_(null, this.m_19749_().m_20183_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!this.m_9236_().m_5776_()) {
                if (owner.m_21224_() || !((PlayerProperties)owner).hasMeatHook() || (double)owner.m_20270_((Entity)this) > this.maxRange) {
                    this.m_6074_();
                }
                if (this.hookedEntity != null) {
                    if (this.hookedEntity.m_213877_()) {
                        this.hookedEntity = null;
                        this.m_142036_();
                    } else {
                        this.m_20248_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20227_(0.8), this.hookedEntity.m_20189_());
                    }
                }
                if (owner.m_21205_() == this.stack && this.isPulling) {
                    Player target = owner;
                    MeatHookEntity origin = this;
                    if (owner.m_150108_() && this.hookedEntity != null) {
                        target = this.hookedEntity;
                        origin = owner;
                    }
                    double pullSpeed = 0.75;
                    Vec3 distance = origin.m_20182_().m_82546_(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
                    Vec3 motion = distance.m_82541_().m_82490_(0.75 * distance.m_82553_() / 6.0);
                    if (Math.abs(distance.f_82480_) < 0.01) {
                        motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
                        this.m_6074_();
                    }
                    Vec3 vec3 = new Vec3(distance.f_82479_, 0.0, distance.f_82481_);
                    Vec3 vec32 = new Vec3((double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f));
                    if (vec3.m_82553_() < vec32.m_82553_() / 1.4) {
                        motion = new Vec3(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                        this.m_6074_();
                    }
                    target.f_19789_ = 0.0f;
                    target.m_20256_(motion);
                    target.f_19864_ = true;
                }
            }
        }
    }

    private void doMicrowaveBeam(Player owner) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime >= 300L) {
            this.lastUpdateTime = currentTime;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getMicrowaveBeam(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        this.m_146922_(((Float)this.f_19804_.m_135370_(FORCED_YAW)).floatValue());
        if (!(this.hookedEntity instanceof LivingEntity)) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            if (owner.m_21224_() || !((PlayerProperties)owner).hasMeatHook() || (double)owner.m_20270_((Entity)this) > this.maxRange) {
                this.m_6074_();
            }
            if (this.hookedEntity != null) {
                if (this.hookedEntity.m_213877_()) {
                    this.hookedEntity = null;
                    this.m_142036_();
                } else if (!(this.hookedEntity instanceof Player) && !(this.hookedEntity instanceof DoomBoss)) {
                    ++this.attachTimer;
                    this.m_20329_(this.hookedEntity);
                    for (int i = 0; i < 2; ++i) {
                        this.hookedEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.hookedEntity.m_20208_(0.5), this.hookedEntity.m_20187_() - 0.25, this.hookedEntity.m_20262_(0.5), (((LivingEntity)this.hookedEntity).m_217043_().m_188500_() - 0.5) * 2.0, -((LivingEntity)this.hookedEntity).m_217043_().m_188500_(), (((LivingEntity)this.hookedEntity).m_217043_().m_188500_() - 0.5) * 2.0);
                    }
                    this.hookedEntity.m_146915_(true);
                    this.hookedEntity.m_20334_(0.0, 0.0, 0.0);
                    this.hookedEntity.m_146924_(true);
                }
            }
        }
        if (this.hookedEntity != null && (float)this.attachTimer >= ((LivingEntity)this.hookedEntity).m_21223_() && this.getVariant() == 1) {
            DoomBaseItem gun;
            this.explode(this.hookedEntity);
            Item item = owner.m_21211_().m_41720_();
            if (item instanceof DoomBaseItem && (gun = (DoomBaseItem)item).getGunTypeEnum() == GunTypeEnum.PLAMSA) {
                owner.m_21205_().m_41622_((int)((double)((LivingEntity)this.hookedEntity).m_21233_() * 0.5), (LivingEntity)owner, s -> owner.m_21190_(owner.m_7655_()));
            }
            if (!this.m_9236_().m_5776_()) {
                ((PlayerProperties)owner).setHasMeatHook(false);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void explode(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), Float.MAX_VALUE);
        }
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_175830_);
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19734_(1);
        areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.5f);
    }

    public void m_6074_() {
        Entity entity;
        if (!this.m_9236_().m_5776_() && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            ((PlayerProperties)owner).setHasMeatHook(false);
            owner.m_20242_(false);
        }
        super.m_6074_();
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_6072_() {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        Entity entity;
        super.m_8060_(blockHitResult);
        this.isPulling = true;
        if (this.getVariant() == 1) {
            this.m_6074_();
        }
        if (!this.m_9236_().m_5776_() && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            if (this.hookedEntity == null && this.getVariant() == 0) {
                owner.m_20242_(true);
            }
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        Entity entity;
        if (!this.m_9236_().m_5776_() && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            if (entityHitResult.m_82443_() != owner && (entityHitResult.m_82443_() instanceof LivingEntity || entityHitResult.m_82443_() instanceof EnderDragonPart) && this.hookedEntity == null) {
                this.hookedEntity = entityHitResult.m_82443_();
                this.f_19804_.m_135381_(HOOKED_ENTITY_ID, (Object)(this.hookedEntity.m_19879_() + 1));
                this.isPulling = true;
            }
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(FORCED_YAW, (Object)Float.valueOf(tag.m_128457_("ForcedYaw")));
        this.maxRange = tag.m_128459_("maxRange");
        this.maxSpeed = tag.m_128459_("maxSpeed");
        this.isPulling = tag.m_128471_("isPulling");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("hookshotItem"));
        Entity entity = this.m_9236_().m_6815_(tag.m_128451_("owner"));
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            this.m_5602_((Entity)owner);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ForcedYaw", ((Float)this.f_19804_.m_135370_(FORCED_YAW)).floatValue());
        tag.m_128347_("maxRange", this.maxRange);
        tag.m_128347_("maxSpeed", this.maxSpeed);
        tag.m_128379_("isPulling", this.isPulling);
        tag.m_128365_("hookshotItem", (Tag)this.stack.m_41739_(new CompoundTag()));
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            tag.m_128405_("owner", owner.m_19879_());
        }
    }

    public void setProperties(ItemStack stack, double maxRange, double maxVelocity, float pitch, float yaw, float roll, float modifierZ) {
        float f = (float)Math.PI / 180;
        float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)((pitch + roll) * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, modifierZ, 0.0f);
        this.stack = stack;
        this.maxRange = maxRange;
        this.maxSpeed = maxVelocity;
    }
}

