/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles.entity;

import java.util.UUID;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoomFireEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 75;
    private UUID casterUuid;
    private float damage;

    public DoomFireEntity(EntityType<DoomFireEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DoomFireEntity(Level worldIn, double x, double y, double z, int warmup, LivingEntity casterIn, float damage) {
        this(Services.ENTITIES_HELPER.getDoomFireEntity(), worldIn);
        this.warmupDelayTicks = warmup;
        this.setCaster(casterIn);
        this.m_20248_(x, y, z);
        this.damage = damage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
    }

    public void setCaster(@Nullable LivingEntity owner) {
        this.casterUuid = owner == null ? null : owner.m_20148_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.explode();
        super.m_142687_(reason);
    }

    protected void explode() {
        this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(8.0)).forEach(this::doDamage);
    }

    private void doDamage(Entity target) {
        if (target instanceof LivingEntity) {
            if (target instanceof DemonEntity) {
                return;
            }
            target.f_19802_ = 0;
            target.m_6469_(this.m_269291_().m_269233_(), this.damage);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.warmupDelayTicks < 0) {
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.m_6084_() && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60795_()) {
            this.m_9236_().m_46597_(this.m_20183_().m_7494_(), BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)this.m_20183_().m_7494_()));
        }
        this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(1.0)).forEach(e -> {
            if (e.m_6084_() && !(e instanceof DemonEntity)) {
                e.m_7311_(60);
            }
        });
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == this.m_269291_().m_269318_() || source == this.m_269291_().m_269549_() || source == this.m_269291_().m_269387_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6051_() {
        return false;
    }
}

