/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles.entity;

import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class FireProjectile
extends AbstractHurtingProjectile {
    private float directHitDamage = 2.0f;
    private int idleTicks = 0;

    public FireProjectile(EntityType<FireProjectile> entitytype, Level world) {
        super(entitytype, world);
    }

    public FireProjectile(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super(Services.ENTITIES_HELPER.getFireEntity(), shooter, accelX, accelY, accelZ, worldIn);
        this.directHitDamage = directHitDamage;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public boolean m_20068_() {
        return false;
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < 100) {
            super.m_8119_();
        }
        if (this.f_19797_ >= 40) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.m_9236_().m_46801_(this.m_20183_());
        CommonUtils.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = this.m_19749_();
        if (!(entity instanceof Mob) || this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && this.m_9236_().m_46859_(blockpos)) {
            this.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().f_46443_) {
            LivingEntity livingEntity;
            Entity entity = entityHitResult.m_82443_();
            Entity entity1 = this.m_19749_();
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof DemonEntity)) {
                    livingEntity.m_6469_(this.m_269291_().m_269233_(), this.directHitDamage);
                    entity.m_20254_(15);
                }
            }
            if (entity1 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity1;
                if (!(entity instanceof DemonEntity)) {
                    this.m_19970_(livingEntity, entity);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected boolean m_5931_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }
}

