/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierboss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.ai.DemonFloatControl;
import mod.azure.doom.entities.ai.goal.RandomFlyConvergeOnTargetGoal;
import mod.azure.doom.entities.projectiles.entity.DoomFireEntity;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.entities.tierboss.DoomBoss;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class ArchMakyrEntity
extends DemonEntity
implements SmartBrainOwner<ArchMakyrEntity>,
DoomBoss {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(ArchMakyrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ArchMakyrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);

    public ArchMakyrEntity(EntityType<ArchMakyrEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new DemonFloatControl(this);
    }

    @NotNull
    public static AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.55).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22276_, MCDoom.config.archmaykr_health).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> event.setAndContinue(DoomAnimationsDefault.FLYING)).triggerableAnim("death", this.getDeathState() < 5 ? DoomAnimationsDefault.DEATH_PHASEONE : DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("ranged", DoomAnimationsDefault.ATTACKING_AOE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(2);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 2) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(3);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 3) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(4);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 4) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(5);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 5) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    @Override
    public void m_6667_(@NotNull DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            if (source == this.m_269291_().m_269341_()) {
                this.setDeathState(5);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) > 5) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 5) {
                super.m_6667_(source);
            }
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<ArchMakyrEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setRadius(32.0).setPredicate((target, entity) -> target.m_6084_() && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<ArchMakyrEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new StayWithinDistanceOfAttackTarget().speedMod(2.25f), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<ArchMakyrEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(2.0f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<ArchMakyrEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_()), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(2.05f)), new DemonProjectileAttack<DemonEntity>(7).attackInterval(mob -> 240)});
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyConvergeOnTargetGoal(this));
    }

    public int m_6056_() {
        return 99;
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return 0;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    protected boolean m_7341_(@NotNull Entity entity) {
        return false;
    }

    public int m_21230_() {
        return 15;
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public void m_7023_(@NotNull Vec3 movementInput) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setDeathState(compound.m_128451_("Phase"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
        tag.m_128405_("Variant", this.getVariant());
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)2);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 2;
    }

    public void m_147240_(double x, double y, double z) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_217043_().m_188502_());
        return spawnDataIn;
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 1.5f;
    }

    protected SoundEvent m_7515_() {
        return Services.SOUNDS_HELPER.getMAKYR_AMBIENT();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getMAKYR_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getMAKYR_DEATH();
    }

    public int m_5792_() {
        return 1;
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_9236_().m_45933_((Entity)this, aabb).forEach(e -> {
            Player player;
            if (e instanceof ArchMakyrEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (!(!(e instanceof Player) || (player = (Player)e).m_7500_() && player.m_5833_())) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttckingState() > 1) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 10, false, false));
        }
    }

    public void spawnFlames(double x, double z, double maxY, double y) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            DoomFireEntity fire = new DoomFireEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, 1, (LivingEntity)this, MCDoom.config.archmaykr_ranged_damage + this.getExtraDamage());
            fire.m_20254_(this.f_19797_);
            fire.m_6842_(false);
            this.m_9236_().m_7967_((Entity)fire);
        }
    }

    private float getExtraDamage() {
        switch ((Integer)this.f_19804_.m_135370_(DEATH_STATE)) {
            case 1: {
                return MCDoom.config.archmaykr_phaseone_damage_boost;
            }
            case 2: {
                return MCDoom.config.archmaykr_phasetwo_damage_boost;
            }
            case 3: {
                return MCDoom.config.archmaykr_phasethree_damage_boost;
            }
            case 4: {
                return MCDoom.config.archmaykr_phasefour_damage_boost;
            }
        }
        return 0.0f;
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public boolean m_6128_() {
        return true;
    }
}

