/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierboss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.entities.tierboss.DoomBoss;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class GladiatorEntity
extends DemonEntity
implements SmartBrainOwner<GladiatorEntity>,
DoomBoss {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(GladiatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TEXTURE = SynchedEntityData.m_135353_(GladiatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(false).m_7006_(false);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public GladiatorEntity(EntityType<? extends DemonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, MCDoom.config.gladiator_health).m_22268_(Attributes.f_22281_, MCDoom.config.gladiator_melee_damage).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (((GladiatorEntity)event.getAnimatable()).getDeathState() == 0 && event.isMoving() && ((GladiatorEntity)event.getAnimatable()).getAttckingState() < 1) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("walking_phaseone"));
            }
            if (((GladiatorEntity)event.getAnimatable()).getDeathState() == 0 && (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("death_phaseone"));
            }
            if (((GladiatorEntity)event.getAnimatable()).getDeathState() == 1 && (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("death_phasetwo"));
            }
            if (((GladiatorEntity)event.getAnimatable()).getDeathState() == 1 && event.isMoving()) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("walking_phasetwo"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop(((GladiatorEntity)event.getAnimatable()).getDeathState() == 0 ? "idle_phaseone" : "idle_phasetwo"));
        }).triggerableAnim("death", RawAnimation.begin().thenLoop(this.getDeathState() == 0 ? "idle_phaseone" : "idle_phasetwo")).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("walk") && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getPINKY_STEP(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
            }
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("ranged", DoomAnimationsDefault.SHIELD).triggerableAnim("mace", DoomAnimationsDefault.MELEE_PHASETWOTHREE).triggerableAnim("meleeone", DoomAnimationsDefault.MELEE_PHASEONE).triggerableAnim("meleetwo", DoomAnimationsDefault.MELEE_PHASEONETWO).triggerableAnim("melee2one", DoomAnimationsDefault.MELEE_PHASETWOONE).triggerableAnim("melee2two", DoomAnimationsDefault.MELEE_PHASETWOTWO)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void m_6667_(@NotNull DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            if (source == this.m_269291_().m_269341_()) {
                this.setDeathState(1);
            }
            if (this.getDeathState() == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            if (this.getDeathState() == 1) {
                super.m_6667_(source);
            }
            this.triggerAnim("livingController", "death");
        }
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && this.getDeathState() == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && this.getDeathState() == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    protected boolean m_6125_() {
        return true;
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    public int getTextureState() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setTextureState(int state) {
        this.f_19804_.m_135381_(TEXTURE, (Object)state);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setTextureState(compound.m_128451_("Texture"));
        this.setDeathState(compound.m_128451_("Phase"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
        tag.m_128405_("Texture", this.getTextureState());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
        this.f_19804_.m_135372_(TEXTURE, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.getDeathState() == 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 0, false, false));
            } else {
                this.m_21195_(MobEffects.f_19606_);
            }
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<GladiatorEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<GladiatorEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new StrafeTarget().speedMod(0.25f), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<GladiatorEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(0.75f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<GladiatorEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(0.85f)), new DemonProjectileAttack<DemonEntity>(30).attackInterval(mob -> 80).attackDamage(MCDoom.config.cyberdemon_ranged_damage), new DemonMeleeAttack(5)});
    }

    protected void m_8099_() {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean bl = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)MCDoom.config.gladiator_melee_damage + (this.getDeathState() == 1 ? MCDoom.config.gladiator_phaseone_damage_boost : 0.0f));
        if (bl) {
            target.m_20256_(target.m_20184_().m_82542_((double)1.4f, (double)1.4f, (double)1.4f));
            this.m_19970_((LivingEntity)this, target);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.BLOCK);
            target.f_19802_ = 0;
        }
        return true;
    }

    public boolean tryAttack1(Entity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean bl = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)MCDoom.config.gladiator_melee_damage + (this.getDeathState() == 1 ? MCDoom.config.gladiator_phaseone_damage_boost : 0.0f));
        if (bl) {
            target.m_20256_(target.m_20184_().m_82542_((double)1.4f, (double)1.4f, (double)1.4f));
            this.m_19970_((LivingEntity)this, target);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.BLOCK);
            target.f_19802_ = 0;
        }
        return true;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getBARON_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getBARON_DEATH();
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_9236_().m_45933_((Entity)this, aabb).forEach(e -> {
            Player player;
            if (e instanceof GladiatorEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (e instanceof Player && !(player = (Player)e).m_7500_() && !player.m_5833_()) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public void m_147240_(double x, double y, double z) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return this.getAttckingState() != 1 && this.getAttckingState() != 4 && super.m_6469_(source, amount);
    }
}

