/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierboss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.ai.DemonFloatControl;
import mod.azure.doom.entities.ai.goal.RandomFlyConvergeOnTargetGoal;
import mod.azure.doom.entities.projectiles.entity.DoomFireEntity;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.entities.tierboss.DoomBoss;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class MotherDemonEntity
extends DemonEntity
implements SmartBrainOwner<MotherDemonEntity>,
DoomBoss {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(MotherDemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);

    public MotherDemonEntity(EntityType<MotherDemonEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new DemonFloatControl(this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, MCDoom.config.motherdemon_health).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, (double)0.9f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        boolean isDead = this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_();
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> event.setAndContinue(isDead && ((MotherDemonEntity)event.getAnimatable()).getDeathState() == 5 ? DoomAnimationsDefault.DEATH : (isDead && ((MotherDemonEntity)event.getAnimatable()).getDeathState() < 5 ? DoomAnimationsDefault.DEATH_PHASEONE : DoomAnimationsDefault.MOVING))).triggerableAnim("death", DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("ranged", DoomAnimationsDefault.FIRE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    @Override
    public void m_6667_(@NotNull DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            if (source == this.m_269291_().m_269341_()) {
                this.setDeathState(1);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                super.m_6667_(source);
            }
            this.triggerAnim("livingController", "death");
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<MotherDemonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setRadius(32.0).setPredicate((target, entity) -> target.m_6084_() && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<MotherDemonEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new StayWithinDistanceOfAttackTarget().speedMod(0.25f), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<MotherDemonEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(1.0f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<MotherDemonEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_()), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.05f)), new DemonProjectileAttack<DemonEntity>(7).attackInterval(mob -> 240)});
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyConvergeOnTargetGoal(this));
    }

    protected void m_8022_() {
        boolean flag = this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        super.m_8022_();
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_9236_().m_45933_((Entity)this, aabb).forEach(e -> {
            Player player;
            if (e instanceof MotherDemonEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (e instanceof Player && !(player = (Player)e).m_7500_() && !player.m_5833_()) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 9.05f;
    }

    public void spawnFlames(double x, double z, double maxY, double y) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            DoomFireEntity fang = new DoomFireEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, 1, (LivingEntity)this, MCDoom.config.motherdemon_ranged_damage + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? MCDoom.config.motherdemon_phaseone_damage_boos : 0.0f));
            fang.m_20254_(this.f_19797_);
            fang.m_6842_(false);
            this.m_9236_().m_7967_((Entity)fang);
        }
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    protected SoundEvent m_7515_() {
        return Services.SOUNDS_HELPER.getMOTHER_AMBIENT();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getMOTHER_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getMOTHER_DEATH();
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setDeathState(compound.m_128451_("Phase"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public boolean m_6128_() {
        return true;
    }
}

