/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierboss;

import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.entities.tierboss.SpiderMastermindEntity;
import mod.azure.doom.platform.Services;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import org.jetbrains.annotations.NotNull;

public class SpiderMastermind2016Entity
extends SpiderMastermindEntity {
    public SpiderMastermind2016Entity(EntityType<? extends DemonEntity> entityType, Level worldIn) {
        super((EntityType<SpiderMastermindEntity>)entityType, worldIn);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        boolean isDead = this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_();
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (event.isMoving() && !isDead && !this.f_20911_) {
                return event.setAndContinue(DoomAnimationsDefault.WALKING);
            }
            return event.setAndContinue(isDead ? DoomAnimationsDefault.DEATH : DoomAnimationsDefault.IDLE);
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("walk") && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getSPIDERDEMON_AMBIENT(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
            }
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("attack") && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getPLASMA_FIRING(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
            }
        }).triggerableAnim("ranged", DoomAnimationsDefault.ATTACKING)});
    }

    @Override
    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    @Override
    public BrainActivityGroup<SpiderMastermindEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.05f)), new DemonProjectileAttack<DemonEntity>(7).attackInterval(mob -> 40)});
    }

    @Override
    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 2.5f;
    }
}

