/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tiersuperheavy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class MarauderEntity
extends DemonEntity
implements SmartBrainOwner<MarauderEntity> {
    public static final EntityDataAccessor<Boolean> SPAWN = SynchedEntityData.m_135353_(MarauderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public MarauderEntity(EntityType<MarauderEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, MCDoom.config.marauder_health).m_22268_(Attributes.f_22281_, MCDoom.config.marauder_axe_damage).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (((MarauderEntity)event.getAnimatable()).isSpawn()) {
                return event.setAndContinue(DoomAnimationsDefault.SPAWN);
            }
            if (event.isMoving() && this.f_267362_.m_267731_() <= 0.35f) {
                return event.setAndContinue(DoomAnimationsDefault.WALK);
            }
            if (this.f_267362_.m_267731_() > 0.35f) {
                return event.setAndContinue(DoomAnimationsDefault.RUN);
            }
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH);
            }
            return event.setAndContinue(DoomAnimationsDefault.IDLE);
        }).setSoundKeyframeHandler(event -> {
            if (this.m_9236_().m_5776_()) {
                if (event.getKeyframeData().getSound().matches("walk")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getPINKY_STEP(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
                }
                if (event.getKeyframeData().getSound().matches("axe")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getCRUCIBLE_AXE_RIGHT(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
                }
                if (event.getKeyframeData().getSound().matches("portal")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12286_, SoundSource.AMBIENT, 0.5f, 1.0f, false);
                }
            }
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).setSoundKeyframeHandler(event -> {
            if (this.m_9236_().m_5776_()) {
                if (event.getKeyframeData().getSound().matches("attack")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getSUPER_SHOTGUN_SHOOT(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
                }
                if (event.getKeyframeData().getSound().matches("axe_hit")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getCRUCIBLE_STAB(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
                }
                if (event.getKeyframeData().getSound().matches("slash")) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), Services.SOUNDS_HELPER.getCRUCIBLE_AXE_LEFT(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
                }
            }
        }).triggerableAnim("ranged", RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE)).triggerableAnim("death", DoomAnimationsDefault.DEATH).triggerableAnim("slash", RawAnimation.begin().then("energy_slash", Animation.LoopType.PLAY_ONCE)).triggerableAnim("cut", RawAnimation.begin().then("axe_cut", Animation.LoopType.PLAY_ONCE)).triggerableAnim("hook", RawAnimation.begin().then("hook", Animation.LoopType.PLAY_ONCE)).triggerableAnim("melee", RawAnimation.begin().then("axe_attack", Animation.LoopType.PLAY_ONCE))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<MarauderEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<MarauderEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget().startCondition(entity -> !this.isSpawn()), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new MoveToWalkTarget().startCondition(entity -> !this.isSpawn())});
    }

    public BrainActivityGroup<MarauderEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().startCondition(target -> {
            Player player;
            return !this.isSpawn() && !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget().startCondition(entity -> !this.isSpawn())}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(0.5f).startCondition(entity -> !this.isSpawn()), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<MarauderEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.5f)).startCondition(entity -> !this.isSpawn()), new DemonProjectileAttack<DemonEntity>(10).attackInterval(mob -> 90).attackDamage(MCDoom.config.marauder_ssgdamage), new DemonMeleeAttack(10)});
    }

    public boolean isSpawn() {
        return (Boolean)this.f_19804_.m_135370_(SPAWN);
    }

    public void setSpawnState(boolean state) {
        this.f_19804_.m_135381_(SPAWN, (Object)state);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("isSpawn", this.isSpawn());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSpawnState(nbt.m_128471_("isSpawn"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ <= 1) {
            this.setSpawnState(true);
        }
        if (this.isSpawn() && this.f_19797_ > 280) {
            this.setSpawnState(false);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 100, false, false));
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return (!this.isSpawn() || source == this.m_269291_().m_287172_()) && super.m_6469_(source, amount);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_ && !this.isSpawn()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        float f;
        this.tickBrain((LivingEntity)this);
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    public void teleportRandomly() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 10);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            this.teleport(d0, d1, d2);
        }
    }

    private void teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        if (blockstate.m_280555_() && !blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) {
            this.m_20984_(x, y, z, true);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getZOMBIEMAN_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getZOMBIEMAN_DEATH();
    }

    public int m_5792_() {
        return 1;
    }
}

