/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.weapons;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.AzureLibMod;
import mod.azure.azurelib.Keybindings;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.DoomKeyBinds;
import mod.azure.doom.client.render.weapons.GunRender;
import mod.azure.doom.entities.projectiles.BulletEntity;
import mod.azure.doom.entities.projectiles.MeatHookEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.helper.PlayerProperties;
import mod.azure.doom.items.enums.GunTypeEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class DoomBaseItem
extends Item
implements GeoItem {
    protected final GunTypeEnum gunTypeEnum;
    private static final String firing = "firing";
    private static final String controller = "controller";
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    protected DoomBaseItem(GunTypeEnum gunTypeEnum, int maxClipSize) {
        super(new Item.Properties().m_41487_(1).m_41503_(maxClipSize + 1));
        this.gunTypeEnum = gunTypeEnum;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static void shoot(Player player) {
        Item item;
        if (player.m_21205_().m_41773_() < player.m_21205_().m_41776_() - 1 && (item = player.m_21205_().m_41720_()) instanceof DoomBaseItem) {
            DoomBaseItem gunBase = (DoomBaseItem)item;
            if (!player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
                gunBase.singleFire(player.m_21205_(), player.m_9236_(), player);
            }
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), mod.azure.doom.platform.Services.SOUNDS_HELPER.getEMPTY(), SoundSource.PLAYERS, 0.25f, 1.3f);
        }
    }

    public static void shootHook(Player player) {
        DoomBaseItem gunItem;
        Item item;
        ItemStack stack = player.m_21205_();
        if (stack.m_41773_() < stack.m_41776_() - 2 && !player.m_9236_().m_5776_() && !player.m_36335_().m_41519_(stack.m_41720_()) && (item = stack.m_41720_()) instanceof DoomBaseItem && (gunItem = (DoomBaseItem)item).getGunTypeEnum() == GunTypeEnum.SUPERSHOTGUN) {
            player.m_36335_().m_41524_((Item)gunItem, 5);
            if (!((PlayerProperties)player).hasMeatHook()) {
                MeatHookEntity hookShot = new MeatHookEntity(player.m_9236_(), (LivingEntity)player);
                hookShot.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + 10.0f, 0.0f, 20.0f, 1.0f);
                hookShot.setProperties(stack, MCDoom.config.max_meathook_distance, 100.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
                hookShot.m_20088_().m_135381_(MeatHookEntity.FORCED_YAW, (Object)Float.valueOf(player.m_146908_()));
                hookShot.setVariant(0);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11743_, SoundSource.PLAYERS, 1.5f, 1.3f);
                player.m_9236_().m_7967_((Entity)hookShot);
            }
            ((PlayerProperties)player).setHasMeatHook(!((PlayerProperties)player).hasMeatHook());
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        Item item = user.m_21205_().m_41720_();
        if (item instanceof DoomBaseItem) {
            DoomBaseItem gunBase = (DoomBaseItem)item;
            while (!user.m_7500_() && user.m_21205_().m_41773_() != 0 && user.m_150109_().m_18947_(gunBase.getAmmoType()) > 0) {
                CommonUtils.removeAmmo(gunBase.getAmmoType(), user);
                user.m_36335_().m_41524_((Item)gunBase, gunBase.getReloadCoolDown());
                user.m_21205_().m_41622_(-gunBase.getReloadAmount(), (LivingEntity)user, s -> user.m_21190_(hand));
                user.m_21205_().m_41754_(3);
                if (gunBase.getReloadSound() != null) {
                    user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), gunBase.getReloadSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (user.m_9236_().f_46443_ || gunBase.getGunTypeEnum() != GunTypeEnum.SUPERSHOTGUN && gunBase.getGunTypeEnum() != GunTypeEnum.DSHOTGUN && gunBase.getGunTypeEnum() != GunTypeEnum.SHOTGUN) continue;
                gunBase.triggerAnim((Entity)user, GeoItem.getOrAssignId((ItemStack)user.m_21120_(hand), (ServerLevel)((ServerLevel)user.m_9236_())), controller, "reload");
            }
        }
    }

    public GunTypeEnum getGunTypeEnum() {
        return this.gunTypeEnum;
    }

    public Item getAmmoType() {
        switch (this.getGunTypeEnum()) {
            case BALLISTA: 
            case DGAUSS: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getArgentBolts();
            }
            case BFG: 
            case BFG9000: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getBFGCell();
            }
            case DPLASMA: 
            case PLAMSA: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getEngeryCell();
            }
            case DSHOTGUN: 
            case SHOTGUN: 
            case SUPERSHOTGUN: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getShells();
            }
            case HEAVYCANNON: 
            case PISTOL: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getBullets();
            }
            case ROCKETLAUNCHER: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getRocket();
            }
            case UNMAKER: 
            case UNMAYKR: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getUnmaykrBolts();
            }
        }
        return mod.azure.doom.platform.Services.ITEMS_HELPER.getChaingunBullets();
    }

    public SoundEvent getReloadSound() {
        switch (this.getGunTypeEnum()) {
            case BALLISTA: 
            case DGAUSS: 
            case BFG: 
            case BFG9000: 
            case DPLASMA: 
            case PLAMSA: 
            case HEAVYCANNON: 
            case PISTOL: 
            case UNMAKER: 
            case UNMAYKR: 
            case CHAINGUN: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getCLIPRELOAD();
            }
            case DSHOTGUN: 
            case SHOTGUN: 
            case SUPERSHOTGUN: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getSHOTGUNRELOAD();
            }
        }
        return SoundEvents.f_12062_;
    }

    public SoundEvent getFiringSound() {
        switch (this.getGunTypeEnum()) {
            case BALLISTA: 
            case DGAUSS: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getBALLISTA_FIRING();
            }
            case BFG: 
            case BFG9000: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getBFG_FIRING();
            }
            case CHAINGUN: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getCHAINGUN_SHOOT();
            }
            case DPLASMA: 
            case PLAMSA: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getPLASMA_FIRING();
            }
            case DSHOTGUN: 
            case SHOTGUN: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getSHOTGUN_SHOOT();
            }
            case HEAVYCANNON: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getHEAVY_CANNON();
            }
            case PISTOL: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getPISTOL_HIT();
            }
            case ROCKETLAUNCHER: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getROCKET_FIRING();
            }
            case SUPERSHOTGUN: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getSUPER_SHOTGUN_SHOOT();
            }
            case UNMAKER: 
            case UNMAYKR: {
                return mod.azure.doom.platform.Services.SOUNDS_HELPER.getUNMAKYR_FIRE();
            }
        }
        return null;
    }

    public int getReloadAmount() {
        switch (this.getGunTypeEnum()) {
            case BALLISTA: 
            case DGAUSS: {
                return 1;
            }
            case BFG: 
            case BFG9000: 
            case DPLASMA: 
            case PLAMSA: 
            case UNMAKER: 
            case UNMAYKR: {
                return 20;
            }
            case DSHOTGUN: 
            case SHOTGUN: 
            case SUPERSHOTGUN: {
                return 4;
            }
            case HEAVYCANNON: 
            case PISTOL: {
                return 10;
            }
            case ROCKETLAUNCHER: {
                return 2;
            }
        }
        return 50;
    }

    public int getCoolDown() {
        switch (this.gunTypeEnum) {
            case BALLISTA: 
            case DGAUSS: 
            case BFG: 
            case BFG9000: 
            case ROCKETLAUNCHER: {
                return 40;
            }
            case DSHOTGUN: 
            case SHOTGUN: {
                return 18;
            }
            case SUPERSHOTGUN: {
                return 30;
            }
            case DPLASMA: 
            case PLAMSA: 
            case PISTOL: 
            case UNMAKER: 
            case UNMAYKR: {
                return 5;
            }
            case HEAVYCANNON: {
                return 4;
            }
        }
        return 3;
    }

    public int getReloadCoolDown() {
        switch (this.gunTypeEnum) {
            case BALLISTA: 
            case DGAUSS: 
            case BFG: 
            case BFG9000: 
            case SUPERSHOTGUN: {
                return 15;
            }
            case ROCKETLAUNCHER: 
            case UNMAKER: 
            case UNMAYKR: 
            case CHAINGUN: {
                return 10;
            }
            case DPLASMA: 
            case PLAMSA: 
            case DSHOTGUN: 
            case SHOTGUN: 
            case HEAVYCANNON: 
            case PISTOL: {
                return 5;
            }
        }
        return 0;
    }

    private void singleFire(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        player.m_36335_().m_41524_((Item)this, this.getCoolDown());
        CommonUtils.spawnLightSource((Entity)player, player.m_9236_().m_46801_(player.m_20183_()));
        itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        if (this.getFiringSound() != null && itemStack.m_41783_() != null && !itemStack.m_41783_().m_128471_("isAltFiring")) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
        }
        AbstractArrow bullet = null;
        switch (this.gunTypeEnum) {
            case BALLISTA: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.argent_bolt_damage);
                ((BulletEntity)bullet).setParticle(3);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case DGAUSS: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.argent_bolt_damage);
                ((BulletEntity)bullet).setParticle(4);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case BFG: 
            case BFG9000: {
                bullet = CommonUtils.createBFG(level, (LivingEntity)player);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.75f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case CHAINGUN: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.chaingun_bullet_damage);
                ((BulletEntity)bullet).setParticle(2);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case DPLASMA: 
            case PLAMSA: {
                if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128471_("isAltFiring")) {
                    player.m_36335_().m_41524_((Item)this, 30);
                    if (!((PlayerProperties)player).hasMeatHook()) {
                        MeatHookEntity hookShot = new MeatHookEntity(player.m_9236_(), (LivingEntity)player);
                        hookShot.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 20.0f, 1.0f);
                        hookShot.setProperties(itemStack, MCDoom.config.max_meathook_distance, 100.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
                        hookShot.m_20088_().m_135381_(MeatHookEntity.FORCED_YAW, (Object)Float.valueOf(player.m_146908_()));
                        hookShot.setVariant(1);
                        player.m_9236_().m_7967_((Entity)hookShot);
                    }
                    ((PlayerProperties)player).setHasMeatHook(!((PlayerProperties)player).hasMeatHook());
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    if (!((PlayerProperties)player).hasMeatHook()) break;
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                    break;
                }
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.energycell_damage);
                ((BulletEntity)bullet).setParticle(6);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case DSHOTGUN: {
                if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128471_("isAltFiring")) {
                    bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.bullet_damage);
                    ((BulletEntity)bullet).setParticle(7);
                    bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    player.m_36335_().m_41524_((Item)this, 30);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), mod.azure.doom.platform.Services.SOUNDS_HELPER.getHEAVY_CANNON(), SoundSource.PLAYERS, 0.25f, 1.3f);
                    level.m_7967_((Entity)bullet);
                    break;
                }
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.bullet_damage);
                ((BulletEntity)bullet).setParticle(2);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case SHOTGUN: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.shotgun_damage);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case PISTOL: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.bullet_damage);
                ((BulletEntity)bullet).setParticle(1);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case HEAVYCANNON: {
                if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128471_("isAltFiring")) {
                    bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.bullet_damage);
                    ((BulletEntity)bullet).setParticle(8);
                    bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    player.m_36335_().m_41524_((Item)this, this.getCoolDown());
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                    level.m_7967_((Entity)bullet);
                    break;
                }
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.bullet_damage);
                ((BulletEntity)bullet).setParticle(2);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case ROCKETLAUNCHER: {
                bullet = CommonUtils.createRocket(level, itemStack, (LivingEntity)player);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.75f, 1.0f);
                level.m_7967_((Entity)bullet);
                break;
            }
            case SUPERSHOTGUN: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.shotgun_damage);
                ((BulletEntity)bullet).setParticle(2);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                BulletEntity bullet2 = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.shotgun_damage);
                bullet2.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() - 1.0f, 0.0f, 3.0f, 1.0f);
                bullet2.setParticle(2);
                if (EnchantmentHelper.m_44843_((Enchantment)Services.PLATFORM.getIncendairyenchament(), (ItemStack)itemStack) > 0) {
                    bullet2.m_20254_(100);
                }
                level.m_7967_((Entity)bullet2);
                level.m_7967_((Entity)bullet);
                break;
            }
            case UNMAKER: 
            case UNMAYKR: {
                bullet = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.unmaykr_damage);
                ((BulletEntity)bullet).setParticle(5);
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                level.m_7967_((Entity)bullet);
                BulletEntity bullet1 = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.unmaykr_damage);
                bullet1.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + 10.0f, 0.0f, 3.0f, 1.0f);
                if (EnchantmentHelper.m_44843_((Enchantment)Services.PLATFORM.getIncendairyenchament(), (ItemStack)itemStack) > 0) {
                    bullet1.m_20254_(100);
                }
                level.m_7967_((Entity)bullet1);
                BulletEntity bullet2 = CommonUtils.createBullet(level, itemStack, (LivingEntity)player, MCDoom.config.unmaykr_damage);
                bullet2.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() - 10.0f, 0.0f, 3.0f, 1.0f);
                if (EnchantmentHelper.m_44843_((Enchantment)Services.PLATFORM.getIncendairyenchament(), (ItemStack)itemStack) > 0) {
                    bullet2.m_20254_(100);
                }
                level.m_7967_((Entity)bullet2);
            }
        }
        if (bullet != null) {
            if (EnchantmentHelper.m_44843_((Enchantment)Services.PLATFORM.getIncendairyenchament(), (ItemStack)itemStack) > 0) {
                bullet.m_20254_(100);
            }
            if (this.getGunTypeEnum() != GunTypeEnum.BFG && this.getGunTypeEnum() != GunTypeEnum.DPLASMA) {
                bullet.m_7678_(player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 0.0f, 0.0f);
            }
        }
        if (this.gunTypeEnum != GunTypeEnum.PLAMSA) {
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)player.m_9236_())), controller, firing);
        }
        if (this.gunTypeEnum == GunTypeEnum.PLAMSA) {
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)player.m_9236_())), controller, "firing_faster");
        }
    }

    public static void changeFireMode(@NotNull ItemStack stack, @NotNull Player player) {
        if (EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getMicroEnchantment(), (ItemStack)stack) > 0 || EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getStickEnchantment(), (ItemStack)stack) > 0 || EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getMicrowaveEnchantment(), (ItemStack)stack) > 0) {
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128379_("isAltFiring", !stack.m_41784_().m_128471_("isAltFiring"));
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.25f, 1.3f);
            player.m_213846_((Component)Component.m_237113_((String)"Changing Fire Mode"));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, Level world, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        CompoundTag compoundTag = stack.m_41784_();
        if (world.f_46443_ && entity instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof DoomBaseItem && selected) {
            if (Keybindings.RELOAD.m_90859_()) {
                mod.azure.doom.platform.Services.NETWORK.reload(slot);
            }
            if (AzureLibMod.config.useVanillaUseKey) {
                if (Minecraft.m_91087_().f_91066_.f_92095_.m_90857_()) {
                    mod.azure.doom.platform.Services.NETWORK.shoot(slot);
                }
            } else if (Keybindings.FIRE_WEAPON.m_90857_()) {
                mod.azure.doom.platform.Services.NETWORK.shoot(slot);
            }
            if (DoomKeyBinds.HOOK.m_90859_()) {
                mod.azure.doom.platform.Services.NETWORK.hook(slot);
            }
            if (DoomKeyBinds.FIRETYPE.m_90859_() && (this.getGunTypeEnum() == GunTypeEnum.DSHOTGUN || this.getGunTypeEnum() == GunTypeEnum.HEAVYCANNON || this.getGunTypeEnum() == GunTypeEnum.DPLASMA || this.getGunTypeEnum() == GunTypeEnum.PLAMSA)) {
                mod.azure.doom.platform.Services.NETWORK.changeFireMode(stack);
            }
        }
        if (this.getGunTypeEnum() == GunTypeEnum.DSHOTGUN && EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getStickEnchantment(), (ItemStack)stack) > 0 && !compoundTag.m_128441_("isAltFiring")) {
            compoundTag.m_128379_("isAltFiring", false);
        }
        if (this.getGunTypeEnum() == GunTypeEnum.HEAVYCANNON && EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getMicroEnchantment(), (ItemStack)stack) > 0 && !compoundTag.m_128441_("isAltFiring")) {
            compoundTag.m_128379_("isAltFiring", false);
        }
        if (this.getGunTypeEnum() == GunTypeEnum.DPLASMA && EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getMicrowaveEnchantment(), (ItemStack)stack) > 0 && !compoundTag.m_128441_("isAltFiring")) {
            compoundTag.m_128379_("isAltFiring", false);
        }
        if (this.getGunTypeEnum() == GunTypeEnum.PLAMSA && EnchantmentHelper.m_44843_((Enchantment)mod.azure.doom.platform.Services.ITEMS_HELPER.getMicrowaveEnchantment(), (ItemStack)stack) > 0 && !compoundTag.m_128441_("isAltFiring")) {
            compoundTag.m_128379_("isAltFiring", false);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public boolean m_6813_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos blockPos, @NotNull LivingEntity livingEntity) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (itemStack.m_41776_() - itemStack.m_41773_() - 1) + " / " + (itemStack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
        if (this.getGunTypeEnum() == GunTypeEnum.DGAUSS || this.getGunTypeEnum() == GunTypeEnum.DPLASMA || this.getGunTypeEnum() == GunTypeEnum.DSHOTGUN) {
            tooltip.add((Component)Component.m_237115_((String)"doom.doomed_credit.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"doom.doomed_credit1.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("isAltFiring")) {
            tooltip.add((Component)Component.m_237115_((String)("Alt Fire: " + itemStack.m_41784_().m_128471_("isAltFiring"))).m_130940_(ChatFormatting.ITALIC));
        }
        super.m_7373_(itemStack, level, tooltip, tooltipFlag);
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, controller, event -> PlayState.CONTINUE).triggerableAnim(firing, RawAnimation.begin().then(firing, Animation.LoopType.PLAY_ONCE)).triggerableAnim("firing_faster", RawAnimation.begin().then("firing_faster", Animation.LoopType.PLAY_ONCE)).triggerableAnim("hook", RawAnimation.begin().then("hook", Animation.LoopType.PLAY_ONCE)).triggerableAnim("reload", RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE))});
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunRender(DoomBaseItem.this.getGunTypeEnum());
            }
        });
    }
}

