/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.document.LytRect;
import guideme.document.LytSize;
import guideme.document.block.LytBlock;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.render.GuiSprite;
import guideme.render.RenderContext;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;

public class LytGuiSprite
extends LytBlock
implements InteractiveElement {
    @Nullable
    private GuiSprite sprite;
    private ColorValue color = ConstantColor.WHITE;
    private LytSize size = new LytSize(16, 16);

    public LytGuiSprite() {
    }

    public LytGuiSprite(GuiSprite sprite, LytSize size) {
        this.sprite = sprite;
        this.size = size;
    }

    @Nullable
    public GuiSprite getSprite() {
        return this.sprite;
    }

    public void setSprite(@Nullable GuiSprite sprite) {
        this.sprite = sprite;
    }

    public ColorValue getColor() {
        return this.color;
    }

    public void setColor(ColorValue color) {
        this.color = Objects.requireNonNullElse(color, ConstantColor.WHITE);
    }

    public LytSize getSize() {
        return this.size;
    }

    public void setSize(LytSize size) {
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.setSize(new LytSize(width, height));
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        float actualWidth = this.size.width();
        float actualHeight = this.size.height();
        if (actualWidth > (float)availableWidth) {
            float f = (float)availableWidth / actualWidth;
            actualWidth *= f;
            actualHeight *= f;
        }
        return new LytRect(x, y, Math.round(actualWidth), Math.round(actualHeight));
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        if (this.sprite != null) {
            context.fillIcon(this.getBounds(), this.sprite, this.color);
        }
    }
}

