/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.gundurability.item;

import com.corrinedev.gundurability.config.Config;
import com.corrinedev.gundurability.config.DurabilityItemHolder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RepairItem
extends Item {
    private final DurabilityItemHolder.Slots slot;
    private final float repairAmount;
    private final float max;
    private final float min;
    private Pair<String, List<String>> GUNTAG = Pair.of(null, null);

    public RepairItem(int durability, float repairPercent, float max, float min, DurabilityItemHolder.Slots slot, Pair<String, List<String>> gunTags) {
        super(new Item.Properties().m_41503_(durability).setNoRepair());
        this.repairAmount = repairPercent;
        this.slot = slot;
        this.max = max;
        this.min = min;
        this.GUNTAG = gunTags == null ? Pair.of(null, null) : gunTags;
    }

    public RepairItem(int durability, float repairPercent, float max, float min, DurabilityItemHolder.Slots slot) {
        this(durability, repairPercent, max, min, slot, null);
    }

    public DurabilityItemHolder.Slots getSlot() {
        return this.slot;
    }

    public int getRepairAmount(ItemStack stack) {
        int maxDurability = Config.getDurability(stack.m_41784_().m_128461_("GunId"));
        int percent = (int)(this.repairAmount / 100.0f * (float)maxDurability);
        return percent;
    }

    public boolean isBetween(ItemStack stack) {
        int maxDurability = Config.getDurability(stack.m_41784_().m_128461_("GunId"));
        if (maxDurability <= 0) {
            return false;
        }
        float percentMin = this.min / 100.0f * (float)maxDurability;
        float percentMax = this.max / 100.0f * (float)maxDurability;
        int currentDurability = stack.m_41784_().m_128451_("Durability");
        return (float)currentDurability >= percentMin && (float)currentDurability <= percentMax;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        MutableComponent repair = MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"tooltip.gundurability.repair").m_214077_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)(String.valueOf(this.repairAmount) + "%")).m_214077_()).m_130940_(ChatFormatting.AQUA));
        MutableComponent max = MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"tooltip.gundurability.max").m_214077_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)(String.valueOf(this.max) + "%")).m_214077_()).m_130940_(ChatFormatting.AQUA));
        MutableComponent min = MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"tooltip.gundurability.min").m_214077_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)(String.valueOf(this.min) + "%")).m_214077_()).m_130940_(ChatFormatting.AQUA));
        p_41423_.add((Component)repair);
        p_41423_.add((Component)max);
        p_41423_.add((Component)min);
        if (this.GUNTAG.getFirst() != null) {
            MutableComponent compatibleGuns = MutableComponent.m_237204_((ComponentContents)Component.m_237115_((String)"tooltip.gundurability.guns").m_214077_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)((String)this.GUNTAG.getFirst())).m_214077_()).m_130940_(ChatFormatting.AQUA));
            p_41423_.add((Component)compatibleGuns);
        }
    }

    @Nullable
    public List<String> getGunIds() {
        return (List)this.GUNTAG.getSecond();
    }
}

