/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.hiccupslegacy.config.ConfigHandler;
import net.hiccupslegacy.init.HiccupsLegacyModBlockEntities;
import net.hiccupslegacy.init.HiccupsLegacyModBlocks;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.init.HiccupsLegacyModItems;
import net.hiccupslegacy.init.HiccupsLegacyModMenus;
import net.hiccupslegacy.init.HiccupsLegacyModMobEffects;
import net.hiccupslegacy.init.HiccupsLegacyModParticleTypes;
import net.hiccupslegacy.init.HiccupsLegacyModSounds;
import net.hiccupslegacy.init.HiccupsLegacyModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hiccups_legacy")
public class HiccupsLegacyMod {
    public static final Logger LOGGER = LogManager.getLogger(HiccupsLegacyMod.class);
    public static final String MODID = "hiccups_legacy";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("hiccups_legacy", "hiccups_legacy"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public HiccupsLegacyMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        HiccupsLegacyModSounds.REGISTRY.register(bus);
        HiccupsLegacyModBlocks.REGISTRY.register(bus);
        HiccupsLegacyModBlockEntities.REGISTRY.register(bus);
        HiccupsLegacyModItems.REGISTRY.register(bus);
        HiccupsLegacyModEntities.REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_CONFIG);
        HiccupsLegacyModTabs.REGISTRY.register(bus);
        HiccupsLegacyModMobEffects.REGISTRY.register(bus);
        HiccupsLegacyModParticleTypes.REGISTRY.register(bus);
        HiccupsLegacyModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

