/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.hiccupslegacy.entity.LightFuryEntity;
import net.hiccupslegacy.entity.NightFuryEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class DragonBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final Level level;
    @Nullable
    protected Animal partner;
    private int loveTime;
    private final double speedModifier;

    public DragonBreedGoal(Animal pAnimal, double pSpeedModifier) {
        this(pAnimal, pSpeedModifier, pAnimal.getClass());
    }

    public DragonBreedGoal(Animal pAnimal, double pSpeedModifier, Class<? extends Animal> pPartnerClass) {
        this.animal = pAnimal;
        this.level = pAnimal.m_9236_();
        this.partnerClass = pPartnerClass;
        this.speedModifier = pSpeedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.animal.m_27593_()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean m_8045_() {
        return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 60;
    }

    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        Level level;
        this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
        this.animal.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 10.0 && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AgeableMob ageablemob = this.animal.m_142606_(serverLevel, (AgeableMob)this.partner);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.animal, (Mob)this.partner, ageablemob);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            ageablemob = event.getChild();
            if (cancelled) {
                this.animal.m_146762_(24000);
                this.partner.m_146762_(24000);
                this.animal.m_27594_();
                this.partner.m_27594_();
            } else if (ageablemob != null) {
                ageablemob.m_146762_(24000);
                ageablemob.m_7678_(this.animal.m_20185_(), this.animal.m_20186_(), this.animal.m_20189_(), 0.0f, 0.0f);
                this.animal.m_277117_(serverLevel, this.partner, ageablemob);
                serverLevel.m_47205_((Entity)ageablemob);
            }
        }
    }

    @Nullable
    private Animal getFreePartner() {
        ArrayList nearbyPartners = new ArrayList();
        if (this.animal instanceof NightFuryEntity || this.animal instanceof LightFuryEntity) {
            nearbyPartners.addAll(this.level.m_45971_(NightFuryEntity.class, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0)));
            nearbyPartners.addAll(this.level.m_45971_(LightFuryEntity.class, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0)));
        } else {
            nearbyPartners.addAll(this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0)));
        }
        double distance = Double.MAX_VALUE;
        Animal partner = null;
        for (Animal possiblePartner : nearbyPartners) {
            if (!this.animal.m_7848_(possiblePartner) || !(this.animal.m_20280_((Entity)possiblePartner) < distance)) continue;
            partner = possiblePartner;
            distance = this.animal.m_20280_((Entity)possiblePartner);
        }
        return partner;
    }
}

