/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.EnumSet;
import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FlyingDragonFollowOwnerGoal
extends Goal {
    private final FlyingDragonEntity tamable;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public FlyingDragonFollowOwnerGoal(FlyingDragonEntity dragon, double speedModifier, float startDistance, float stopDistance) {
        this.tamable = dragon;
        this.level = dragon.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = dragon.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(dragon.m_21573_() instanceof GroundPathNavigation) && !(dragon.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity owner = this.tamable.m_269323_();
        if (owner == null) {
            return false;
        }
        if (!this.tamable.getWasRidden()) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.m_20280_((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        if (this.tamable.m_20160_()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.m_20160_()) {
            return false;
        }
        return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.tamable.m_21827_() || this.tamable.m_20159_() || this.tamable.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
        this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
        }
    }
}

