/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HurtByTargetDragonGoal
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private static final int ALERT_RANGE_Y = 10;
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    @Nullable
    private Class<?>[] toIgnoreAlert;

    public HurtByTargetDragonGoal(PathfinderMob dragon, Class<?> ... classesToIgnore) {
        super((Mob)dragon, true);
        this.toIgnoreDamage = classesToIgnore;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.f_26135_.m_20160_()) {
            return false;
        }
        int hurtTimestamp = this.f_26135_.m_21213_();
        LivingEntity hurtByMob = this.f_26135_.m_21188_();
        Mob mob = this.f_26135_;
        if (mob instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)mob;
            if (hurtByMob instanceof TamableAnimal) {
                TamableAnimal hurtByTamable = (TamableAnimal)hurtByMob;
                if (tamableAnimal.m_269323_() == hurtByTamable.m_269323_()) {
                    return false;
                }
            }
        }
        if (hurtTimestamp != this.timestamp && hurtByMob != null) {
            if (hurtByMob.m_6095_() == EntityType.f_20532_ && this.f_26135_.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                return false;
            }
            for (Class<?> classToIgnore : this.toIgnoreDamage) {
                if (!classToIgnore.isAssignableFrom(hurtByMob.getClass())) continue;
                return false;
            }
            return this.m_26150_(hurtByMob, HURT_BY_TARGETING);
        }
        return false;
    }

    public HurtByTargetDragonGoal setAlertOthers(Class<?> ... classes) {
        this.alertSameType = true;
        this.toIgnoreAlert = classes;
        return this;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.f_26135_.m_21188_());
        this.f_26137_ = this.f_26135_.m_5448_();
        this.timestamp = this.f_26135_.m_21213_();
        this.f_26138_ = 300;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.m_8056_();
    }

    protected void alertOthers() {
        double followDistance = this.m_7623_();
        AABB distance = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(followDistance, 10.0, followDistance);
        List entitiesOfClass = this.f_26135_.m_9236_().m_6443_(this.f_26135_.getClass(), distance, EntitySelector.f_20408_);
        Iterator iterator = entitiesOfClass.iterator();
        while (iterator.hasNext()) {
            Mob entity = (Mob)iterator.next();
            if (this.f_26135_ == entity || entity.m_5448_() != null || this.f_26135_ instanceof TamableAnimal && ((TamableAnimal)this.f_26135_).m_269323_() != ((TamableAnimal)entity).m_269323_() || entity.m_7307_((Entity)this.f_26135_.m_21188_())) continue;
            if (this.toIgnoreAlert != null) {
                boolean alert = false;
                for (Class<?> classToIgnore : this.toIgnoreAlert) {
                    if (entity.getClass() != classToIgnore) continue;
                    alert = true;
                    break;
                }
                if (alert) continue;
            }
            this.alertOther(entity, this.f_26135_.m_21188_());
        }
        return;
    }

    protected void alertOther(Mob mob, LivingEntity livingEntity) {
        mob.m_6710_(livingEntity);
    }
}

