/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.client.model;

import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FlyingDragonModel<T extends FlyingDragonEntity>
extends EntityModel<T> {
    protected abstract ModelPart getLeftWingPart();

    protected abstract ModelPart getRightWingPart();

    protected ModelPart getRightWingEndPart() {
        return null;
    }

    protected ModelPart getLeftWingEndPart() {
        return null;
    }

    protected ModelPart[] getTailParts() {
        return null;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float velocityY = (float)entity.m_20184_().f_82480_;
        float wingSpeedMultiplier = 1.0f;
        if ((double)velocityY < -0.4) {
            wingSpeedMultiplier = 0.0f;
        } else if ((double)velocityY <= 0.4) {
            ageInTicks *= 0.5f;
        }
        float baseMultiplier = 0.4f;
        float targetRightRot = Mth.m_14031_((float)(ageInTicks * baseMultiplier)) * 0.6f * wingSpeedMultiplier;
        float targetLeftRot = Mth.m_14031_((float)(ageInTicks * baseMultiplier + 3.0f)) * 0.6f * wingSpeedMultiplier;
        float smoothFactor = 0.2f;
        this.getRightWingPart().f_104205_ = Mth.m_14179_((float)smoothFactor, (float)((FlyingDragonEntity)((Object)entity)).prevRightWingRot, (float)targetRightRot);
        this.getLeftWingPart().f_104205_ = Mth.m_14179_((float)smoothFactor, (float)((FlyingDragonEntity)((Object)entity)).prevLeftWingRot, (float)targetLeftRot);
        if (this.getRightWingEndPart() != null) {
            targetRightRot = Mth.m_14031_((float)(ageInTicks * baseMultiplier - 1.3f)) * 0.6f * wingSpeedMultiplier;
            ((FlyingDragonEntity)((Object)entity)).prevRightWingEndRot = this.getRightWingEndPart().f_104205_ = Mth.m_14179_((float)smoothFactor, (float)((FlyingDragonEntity)((Object)entity)).prevRightWingEndRot, (float)targetRightRot);
        }
        if (this.getLeftWingEndPart() != null) {
            targetLeftRot = Mth.m_14031_((float)(ageInTicks * baseMultiplier + 1.7f)) * 0.6f * wingSpeedMultiplier;
            ((FlyingDragonEntity)((Object)entity)).prevLeftWingEndRot = this.getLeftWingEndPart().f_104205_ = Mth.m_14179_((float)smoothFactor, (float)((FlyingDragonEntity)((Object)entity)).prevLeftWingEndRot, (float)targetLeftRot);
        }
        ((FlyingDragonEntity)((Object)entity)).prevRightWingRot = this.getRightWingPart().f_104205_;
        ((FlyingDragonEntity)((Object)entity)).prevLeftWingRot = this.getLeftWingPart().f_104205_;
        if (this.getTailParts() != null && this.getTailParts().length != 0) {
            ModelPart[] tailSegments = this.getTailParts();
            float bodyRotDelta = (float)(-Math.toRadians(((FlyingDragonEntity)((Object)entity)).f_20883_ - ((FlyingDragonEntity)((Object)entity)).f_20884_)) * 3.0f;
            while (((FlyingDragonEntity)((Object)entity)).tailRotationHistory.size() < tailSegments.length) {
                ((FlyingDragonEntity)((Object)entity)).tailRotationHistory.add(Float.valueOf(0.0f));
            }
            for (int i = 0; i < tailSegments.length; ++i) {
                tailSegments[i].f_104204_ = Mth.m_14179_((float)0.05f, (float)((FlyingDragonEntity)((Object)entity)).tailRotationHistory.get(i).floatValue(), (float)(bodyRotDelta * (1.0f - (float)i / 10.0f)));
                ((FlyingDragonEntity)((Object)entity)).tailRotationHistory.set(i, Float.valueOf(tailSegments[i].f_104204_));
            }
        }
    }
}

